/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.reduction;

import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.ReasonerJob;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.reduction.SaturationJobForTransitiveReduction;
import org.semanticweb.elk.reasoner.reduction.SaturationJobRoot;
import org.semanticweb.elk.reasoner.reduction.SaturationJobSuperClass;
import org.semanticweb.elk.reasoner.reduction.SaturationJobVisitor;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionJob;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionListener;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalent;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputUnsatisfiable;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionState;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationFactory;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationListener;
import org.semanticweb.elk.reasoner.saturation.classes.ContextClassSaturation;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Context;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class TransitiveReductionFactory<R extends IndexedClassExpression, J extends TransitiveReductionJob<R>>
implements InputProcessorFactory<J, Engine> {
    private static final Logger LOGGER_ = Logger.getLogger(TransitiveReductionFactory.class);
    private final TransitiveReductionListener<J, Engine> listener;
    private final SaturationOutputProcessor saturationOutputProcessor = new SaturationOutputProcessor();
    private final Queue<SaturationJobSuperClass<R, J>> auxJobQueue;
    private final ClassExpressionSaturationFactory<SaturationJobForTransitiveReduction<R, ?, J>> saturationFactory;

    public TransitiveReductionFactory(OntologyIndex ontologyIndex, int maxWorkers, TransitiveReductionListener<J, Engine> listener) {
        this.listener = listener;
        this.auxJobQueue = new ConcurrentLinkedQueue<SaturationJobSuperClass<R, J>>();
        this.saturationFactory = new ClassExpressionSaturationFactory(ontologyIndex, maxWorkers, new ThisClassExpressionSaturationListener());
    }

    public void printStatistics() {
        this.saturationFactory.printStatistics();
    }

    @Override
    public Engine getEngine() {
        return new Engine();
    }

    public class Engine
    implements InputProcessor<J> {
        private final ClassExpressionSaturationFactory.Engine saturationEngine;

        private Engine() {
            this.saturationEngine = TransitiveReductionFactory.this.saturationFactory.getEngine();
        }

        @Override
        public final void submit(J job) {
            IndexedClassExpression root = (IndexedClassExpression)((ReasonerJob)job).getInput();
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(root + ": transitive reduction started"));
            }
            this.saturationEngine.submit(new SaturationJobRoot(job));
        }

        @Override
        public final void process() throws InterruptedException {
            while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.saturationEngine.process();
                SaturationJobForTransitiveReduction nextJob = (SaturationJobForTransitiveReduction)TransitiveReductionFactory.this.auxJobQueue.poll();
                if (nextJob == null) break;
                this.saturationEngine.submit(nextJob);
            }
        }

        @Override
        public void finish() {
            this.saturationEngine.finish();
        }
    }

    private class SaturationOutputProcessor
    implements SaturationJobVisitor<R, J> {
        private SaturationOutputProcessor() {
        }

        @Override
        public void visit(SaturationJobRoot<R, J> saturationJob) throws InterruptedException {
            Object initiatorJob = saturationJob.initiatorJob;
            IndexedClassExpression root = (IndexedClassExpression)((ReasonerJob)initiatorJob).getInput();
            Context saturation = root.getContext();
            if (!((ContextClassSaturation)saturation).isSatisfiable()) {
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)(root + ": transitive reduction finished: unsatisfiable"));
                }
                TransitiveReductionOutputUnsatisfiable<IndexedClassExpression> output = new TransitiveReductionOutputUnsatisfiable<IndexedClassExpression>(root);
                ((TransitiveReductionJob)initiatorJob).setOutput(output);
                TransitiveReductionFactory.this.listener.notifyFinished(initiatorJob);
                return;
            }
            TransitiveReductionState state = new TransitiveReductionState(initiatorJob);
            this.processTransitiveReductionState(state);
        }

        @Override
        public void visit(SaturationJobSuperClass<R, J> saturationJob) throws InterruptedException {
            IndexedClass candidate = (IndexedClass)saturationJob.getInput();
            TransitiveReductionState state = saturationJob.state;
            this.updateTransitiveReductionOutput(state.output, candidate, candidate.getContext());
            this.processTransitiveReductionState(state);
        }

        private void processTransitiveReductionState(TransitiveReductionState<R, J> state) throws InterruptedException {
            Iterator<IndexedClassExpression> superClassExpressionsIterator = state.superClassExpressionsIterator;
            while (superClassExpressionsIterator.hasNext()) {
                IndexedClassExpression next = superClassExpressionsIterator.next();
                if (!(next instanceof IndexedClass)) continue;
                IndexedClass candidate = (IndexedClass)next;
                Context candidateSaturation = candidate.getContext();
                if (candidateSaturation == null || !((ContextClassSaturation)candidateSaturation).isSaturated()) {
                    TransitiveReductionFactory.this.auxJobQueue.add(new SaturationJobSuperClass(candidate, state));
                    return;
                }
                this.updateTransitiveReductionOutput(state.output, candidate, candidateSaturation);
            }
            TransitiveReductionOutputEquivalentDirect output = state.output;
            ((TransitiveReductionJob)state.initiatorJob).setOutput(state.output);
            TransitiveReductionFactory.this.listener.notifyFinished(state.initiatorJob);
            if (LOGGER_.isTraceEnabled()) {
                IndexedClassExpression root = output.root;
                LOGGER_.trace((Object)(root + ": transitive reduction finished"));
                for (TransitiveReductionOutputEquivalent<IndexedClass> direct : output.directSuperClasses) {
                    LOGGER_.trace((Object)(root + ": direct super class " + direct.getRoot()));
                }
            }
        }

        private void updateTransitiveReductionOutput(TransitiveReductionOutputEquivalentDirect<R> output, IndexedClass candidate, Context candidateSaturation) {
            IndexedClassExpression root = output.root;
            if (candidate == root) {
                output.equivalent.add(candidate.getElkClass());
                return;
            }
            Set<IndexedClassExpression> candidateSupers = ((ContextClassSaturation)candidateSaturation).getSuperClassExpressions();
            if (candidateSupers.contains(root)) {
                output.equivalent.add(candidate.getElkClass());
                return;
            }
            Iterator<TransitiveReductionOutputEquivalent<IndexedClass>> iteratorDirectSuperClasses = output.directSuperClasses.iterator();
            while (iteratorDirectSuperClasses.hasNext()) {
                TransitiveReductionOutputEquivalent<IndexedClass> directSuperClassEquivalent = iteratorDirectSuperClasses.next();
                IndexedClass directSuperClass = (IndexedClass)directSuperClassEquivalent.getRoot();
                if (((ContextClassSaturation)directSuperClass.getContext()).getSuperClassExpressions().contains(candidate)) {
                    if (candidateSupers.contains(directSuperClass)) {
                        directSuperClassEquivalent.equivalent.add(candidate.getElkClass());
                    }
                    return;
                }
                if (!candidateSupers.contains(directSuperClass)) continue;
                iteratorDirectSuperClasses.remove();
            }
            TransitiveReductionOutputEquivalent<IndexedClass> candidateOutput = new TransitiveReductionOutputEquivalent<IndexedClass>(candidate);
            candidateOutput.equivalent.add(candidate.getElkClass());
            output.directSuperClasses.add(candidateOutput);
        }
    }

    private class ThisClassExpressionSaturationListener
    implements ClassExpressionSaturationListener<SaturationJobForTransitiveReduction<R, ?, J>, ClassExpressionSaturationFactory.Engine> {
        private ThisClassExpressionSaturationListener() {
        }

        @Override
        public void notifyFinished(SaturationJobForTransitiveReduction<R, ?, J> output) throws InterruptedException {
            output.accept(TransitiveReductionFactory.this.saturationOutputProcessor);
        }
    }
}

