/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkAxiomIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkObjectIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectCache;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.util.collections.Operations;

public class OntologyIndexImpl
extends IndexedObjectCache
implements OntologyIndex {
    private IndexedClass indexedOwlThing;
    private IndexedClass indexedOwlNothing;
    private final ElkObjectIndexerVisitor elkObjectIndexer = new ElkObjectIndexerVisitor(this);
    private final ElkAxiomIndexerVisitor axiomInserter = new ElkAxiomIndexerVisitor(this, true);
    private final ElkAxiomIndexerVisitor axiomDeleter = new ElkAxiomIndexerVisitor(this, false);
    protected Collection<IndexedObjectProperty> reflexiveObjectProperties;

    public OntologyIndexImpl() {
        this.indexPredefined();
    }

    @Override
    public void clear() {
        super.clear();
        this.indexPredefined();
    }

    private void indexPredefined() {
        this.indexedOwlThing = this.axiomInserter.indexClassDeclaration(PredefinedElkClass.OWL_THING);
        this.indexedOwlNothing = this.axiomInserter.indexClassDeclaration(PredefinedElkClass.OWL_NOTHING);
    }

    @Override
    public IndexedClassExpression getIndexed(ElkClassExpression representative) {
        IndexedClassExpression result = representative.accept(this.elkObjectIndexer);
        if (result.occurs()) {
            return result;
        }
        return null;
    }

    @Override
    public IndexedPropertyChain getIndexed(ElkSubObjectPropertyExpression elkSubObjectPropertyExpression) {
        IndexedPropertyChain result = elkSubObjectPropertyExpression.accept(this.elkObjectIndexer);
        if (result.occurs()) {
            return result;
        }
        return null;
    }

    @Override
    public Collection<IndexedClassExpression> getIndexedClassExpressions() {
        return this.indexedClassExpressionLookup;
    }

    @Override
    public Collection<IndexedClass> getIndexedClasses() {
        return new AbstractCollection<IndexedClass>(){

            @Override
            public Iterator<IndexedClass> iterator() {
                return Operations.filter(OntologyIndexImpl.this.getIndexedClassExpressions(), IndexedClass.class).iterator();
            }

            @Override
            public int size() {
                return OntologyIndexImpl.this.indexedClassCount;
            }
        };
    }

    @Override
    public Collection<IndexedIndividual> getIndexedIndividuals() {
        return new AbstractCollection<IndexedIndividual>(){

            @Override
            public Iterator<IndexedIndividual> iterator() {
                return Operations.filter(OntologyIndexImpl.this.getIndexedClassExpressions(), IndexedIndividual.class).iterator();
            }

            @Override
            public int size() {
                return OntologyIndexImpl.this.indexedIndividualCount;
            }
        };
    }

    @Override
    public Collection<IndexedPropertyChain> getIndexedPropertyChains() {
        return this.indexedPropertyChainLookup;
    }

    @Override
    public Collection<IndexedObjectProperty> getIndexedObjectProperties() {
        return new AbstractCollection<IndexedObjectProperty>(){

            @Override
            public Iterator<IndexedObjectProperty> iterator() {
                return Operations.filter(OntologyIndexImpl.this.getIndexedPropertyChains(), IndexedObjectProperty.class).iterator();
            }

            @Override
            public int size() {
                return OntologyIndexImpl.this.indexedObjectPropertyCount;
            }
        };
    }

    @Override
    public ElkAxiomProcessor getAxiomInserter() {
        return this.axiomInserter;
    }

    @Override
    public ElkAxiomProcessor getAxiomDeleter() {
        return this.axiomDeleter;
    }

    @Override
    public Collection<IndexedObjectProperty> getReflexiveObjectProperties() {
        return this.reflexiveObjectProperties;
    }

    protected void addReflexiveObjectProperty(IndexedObjectProperty reflexiveObjectProperty) {
        if (this.reflexiveObjectProperties == null) {
            this.reflexiveObjectProperties = new LinkedList<IndexedObjectProperty>();
        }
        this.reflexiveObjectProperties.add(reflexiveObjectProperty);
    }

    protected boolean removeReflexiveObjectProperty(IndexedObjectProperty reflexiveObjectProperty) {
        boolean success = this.reflexiveObjectProperties.remove(reflexiveObjectProperty);
        if (this.reflexiveObjectProperties.isEmpty()) {
            this.reflexiveObjectProperties = null;
        }
        return success;
    }

    @Override
    public IndexedClass getIndexedOwlThing() {
        return this.indexedOwlThing;
    }

    @Override
    public IndexedClass getIndexedOwlNothing() {
        return this.indexedOwlNothing;
    }
}

