/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import org.semanticweb.elk.reasoner.indexing.entries.IndexedEntryConverter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectFilter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.util.collections.entryset.KeyEntry;
import org.semanticweb.elk.util.collections.entryset.KeyEntryFactory;
import org.semanticweb.elk.util.collections.entryset.KeyEntryHashSet;

public class IndexedObjectCache
implements IndexedObjectFilter {
    protected final KeyEntryHashSet<IndexedClassExpression> indexedClassExpressionLookup;
    protected final KeyEntryHashSet<IndexedPropertyChain> indexedPropertyChainLookup;
    protected int indexedClassCount = 0;
    protected int indexedIndividualCount = 0;
    protected int indexedObjectPropertyCount = 0;
    IndexedClassExpressionViewFactory indexedClassExpressionViewFactory = new IndexedClassExpressionViewFactory();
    IndexedPropertyChainViewFactory indexedPropertyChainViewFactory = new IndexedPropertyChainViewFactory();

    protected IndexedObjectCache() {
        this.indexedClassExpressionLookup = new KeyEntryHashSet<IndexedClassExpression>(this.indexedClassExpressionViewFactory, 1024);
        this.indexedPropertyChainLookup = new KeyEntryHashSet<IndexedPropertyChain>(this.indexedPropertyChainViewFactory, 128);
    }

    protected void clear() {
        this.indexedClassExpressionLookup.clear();
        this.indexedPropertyChainLookup.clear();
        this.indexedClassCount = 0;
        this.indexedIndividualCount = 0;
        this.indexedObjectPropertyCount = 0;
    }

    @Override
    public IndexedClassExpression filter(IndexedClassExpression ice) {
        IndexedClassExpression result = this.indexedClassExpressionLookup.get(ice);
        if (result == null) {
            return ice;
        }
        return result;
    }

    @Override
    public IndexedPropertyChain filter(IndexedPropertyChain ipc) {
        IndexedPropertyChain result = this.indexedPropertyChainLookup.get(ipc);
        if (result == null) {
            return ipc;
        }
        return result;
    }

    protected void add(IndexedClassExpression ice) {
        this.indexedClassExpressionLookup.merge(ice);
        if (ice instanceof IndexedClass) {
            ++this.indexedClassCount;
        } else if (ice instanceof IndexedIndividual) {
            ++this.indexedIndividualCount;
        }
    }

    protected void add(IndexedPropertyChain ipc) {
        this.indexedPropertyChainLookup.merge(ipc);
        if (ipc instanceof IndexedObjectProperty) {
            ++this.indexedObjectPropertyCount;
        }
    }

    protected void remove(IndexedClassExpression ice) {
        this.indexedClassExpressionLookup.removeEntry(ice);
        if (ice instanceof IndexedClass) {
            --this.indexedClassCount;
        } else if (ice instanceof IndexedIndividual) {
            --this.indexedIndividualCount;
        }
    }

    protected void remove(IndexedPropertyChain ipc) {
        this.indexedPropertyChainLookup.removeEntry(ipc);
        if (ipc instanceof IndexedObjectProperty) {
            --this.indexedObjectPropertyCount;
        }
    }

    class IndexedPropertyChainViewFactory
    implements KeyEntryFactory<IndexedPropertyChain> {
        final IndexedEntryConverter<IndexedPropertyChain> converter = new IndexedEntryConverter();

        IndexedPropertyChainViewFactory() {
        }

        @Override
        public KeyEntry<IndexedPropertyChain, ? extends IndexedPropertyChain> createEntry(IndexedPropertyChain key) {
            return (KeyEntry)((Object)key.accept(this.converter));
        }
    }

    class IndexedClassExpressionViewFactory
    implements KeyEntryFactory<IndexedClassExpression> {
        final IndexedEntryConverter<IndexedClassExpression> converter = new IndexedEntryConverter();

        IndexedClassExpressionViewFactory() {
        }

        @Override
        public KeyEntry<IndexedClassExpression, ? extends IndexedClassExpression> createEntry(IndexedClassExpression key) {
            return (KeyEntry)((Object)key.accept(this.converter));
        }
    }
}

