/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDisjointnessAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionVisitor;
import org.semanticweb.elk.reasoner.saturation.rulesystem.Context;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.hashing.HashGenerator;

public abstract class IndexedClassExpression {
    private List<IndexedClassExpression> toldSuperClassExpressions_;
    private Map<IndexedClassExpression, IndexedObjectIntersectionOf> negConjunctionsByConjunct_;
    private Collection<IndexedObjectSomeValuesFrom> negExistentials_;
    private Set<IndexedClassExpression> disjointClasses_;
    protected List<IndexedDisjointnessAxiom> disjointnessAxioms;
    int positiveOccurrenceNo = 0;
    int negativeOccurrenceNo = 0;
    protected final AtomicReference<Context> context = new AtomicReference();
    private final int hashCode_ = HashGenerator.generateNextHashCode();

    public boolean occurs() {
        return this.positiveOccurrenceNo > 0 || this.negativeOccurrenceNo > 0;
    }

    public boolean occursNegatively() {
        return this.negativeOccurrenceNo > 0;
    }

    public boolean occursPositively() {
        return this.positiveOccurrenceNo > 0;
    }

    abstract void updateOccurrenceNumbers(int var1, int var2, int var3);

    public List<IndexedClassExpression> getToldSuperClassExpressions() {
        return this.toldSuperClassExpressions_;
    }

    public Map<IndexedClassExpression, IndexedObjectIntersectionOf> getNegConjunctionsByConjunct() {
        return this.negConjunctionsByConjunct_;
    }

    public Collection<IndexedObjectSomeValuesFrom> getNegExistentials() {
        return this.negExistentials_;
    }

    public Set<IndexedClassExpression> getDisjointClasses() {
        return this.disjointClasses_;
    }

    public List<IndexedDisjointnessAxiom> getDisjointnessAxioms() {
        return this.disjointnessAxioms;
    }

    protected void addToldSuperClassExpression(IndexedClassExpression superClassExpression) {
        if (this.toldSuperClassExpressions_ == null) {
            this.toldSuperClassExpressions_ = new ArrayList<IndexedClassExpression>(1);
        }
        this.toldSuperClassExpressions_.add(superClassExpression);
    }

    protected boolean removeToldSuperClassExpression(IndexedClassExpression superClassExpression) {
        boolean success = false;
        if (this.toldSuperClassExpressions_ != null) {
            success = this.toldSuperClassExpressions_.remove(superClassExpression);
            if (this.toldSuperClassExpressions_.isEmpty()) {
                this.toldSuperClassExpressions_ = null;
            }
        }
        return success;
    }

    protected void addNegConjunctionByConjunct(IndexedObjectIntersectionOf conjunction, IndexedClassExpression conjunct) {
        if (this.negConjunctionsByConjunct_ == null) {
            this.negConjunctionsByConjunct_ = new HashMap<IndexedClassExpression, IndexedObjectIntersectionOf>(4);
        }
        if (this.negConjunctionsByConjunct_.put(conjunct, conjunction) != null) {
            throw new RuntimeException("Internal error: duplicate indexing in IndexedClassExpression.addNegConjunctionByConjunct.");
        }
    }

    protected boolean removeNegConjunctionByConjunct(IndexedObjectIntersectionOf conjunction, IndexedClassExpression conjunct) {
        boolean success = false;
        if (this.negConjunctionsByConjunct_ != null) {
            boolean bl = success = this.negConjunctionsByConjunct_.remove(conjunct) != null;
            if (this.negConjunctionsByConjunct_.isEmpty()) {
                this.negConjunctionsByConjunct_ = null;
            }
        }
        return success;
    }

    protected void addNegExistential(IndexedObjectSomeValuesFrom existential) {
        if (this.negExistentials_ == null) {
            this.negExistentials_ = new ArrayList<IndexedObjectSomeValuesFrom>(1);
        }
        this.negExistentials_.add(existential);
    }

    protected boolean removeNegExistential(IndexedObjectSomeValuesFrom existential) {
        boolean success = false;
        if (this.negExistentials_ != null) {
            success = this.negExistentials_.remove(existential);
            if (this.negExistentials_.isEmpty()) {
                this.negExistentials_ = null;
            }
        }
        return success;
    }

    protected void addDisjointClass(IndexedClassExpression disjointClass) {
        if (this.disjointClasses_ == null) {
            this.disjointClasses_ = new ArrayHashSet<IndexedClassExpression>();
        }
        this.disjointClasses_.add(disjointClass);
    }

    protected boolean removeDisjointClass(IndexedClassExpression disjointClass) {
        boolean success = false;
        if (this.disjointClasses_ != null) {
            success = this.disjointClasses_.remove(disjointClass);
            if (this.disjointClasses_.isEmpty()) {
                this.disjointClasses_ = null;
            }
        }
        return success;
    }

    protected void addDisjointnessAxiom(IndexedDisjointnessAxiom disjointnessAxiom) {
        if (this.disjointnessAxioms == null) {
            this.disjointnessAxioms = new LinkedList<IndexedDisjointnessAxiom>();
        }
        this.disjointnessAxioms.add(disjointnessAxiom);
    }

    protected boolean removeDisjointnessAxiom(IndexedDisjointnessAxiom disjointnessAxiom) {
        boolean success = false;
        if (this.disjointnessAxioms != null) {
            Iterator<IndexedDisjointnessAxiom> i = this.disjointnessAxioms.iterator();
            while (i.hasNext()) {
                if (!((Object)i.next().getMembers()).equals(disjointnessAxiom.getMembers())) continue;
                i.remove();
                break;
            }
            if (this.disjointnessAxioms.isEmpty()) {
                this.disjointnessAxioms = null;
            }
        }
        return success;
    }

    public Context getContext() {
        return this.context.get();
    }

    public boolean setContext(Context context) {
        return this.context.compareAndSet(null, context);
    }

    public void resetContext() {
        this.context.set(null);
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    public abstract <O> O accept(IndexedClassExpressionVisitor<O> var1);

    public abstract String toString();
}

