/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassEntityVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassVisitor;

public class IndexedClass
extends IndexedClassEntity {
    protected final ElkClass elkClass;
    protected int occurrenceNo = 0;

    protected IndexedClass(ElkClass elkClass) {
        this.elkClass = elkClass;
    }

    public ElkClass getElkClass() {
        return this.elkClass;
    }

    public <O> O accept(IndexedClassVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(IndexedClassEntityVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected void updateOccurrenceNumbers(int increment, int positiveIncrement, int negativeIncrement) {
        this.occurrenceNo += increment;
        this.positiveOccurrenceNo += positiveIncrement;
        this.negativeOccurrenceNo += negativeIncrement;
    }

    @Override
    public boolean occurs() {
        return this.occurrenceNo > 0;
    }

    @Override
    public String toString() {
        return '<' + this.getElkClass().getIri().getFullIriAsString() + '>';
    }
}

