/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.AbstractElkAxiomIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkObjectIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDisjointnessAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectFilter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexingException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.OntologyIndexImpl;
import org.semanticweb.elk.util.logging.ElkMessage;

public class ElkAxiomIndexerVisitor
extends AbstractElkAxiomIndexerVisitor {
    private static final Logger LOGGER_ = Logger.getLogger(ElkAxiomIndexerVisitor.class);
    private final OntologyIndexImpl ontologyIndex;
    private final int multiplicity;
    private final ElkObjectIndexerVisitor neutralIndexer;
    private final ElkObjectIndexerVisitor positiveIndexer;
    private final ElkObjectIndexerVisitor negativeIndexer;

    public ElkAxiomIndexerVisitor(OntologyIndexImpl ontologyIndex, boolean insert) {
        this.ontologyIndex = ontologyIndex;
        this.multiplicity = insert ? 1 : -1;
        this.neutralIndexer = new ElkObjectIndexerVisitor(new UpdateCacheFilter(this.multiplicity, 0, 0));
        this.positiveIndexer = new ElkObjectIndexerVisitor(new UpdateCacheFilter(this.multiplicity, this.multiplicity, 0));
        this.negativeIndexer = new ElkObjectIndexerVisitor(new UpdateCacheFilter(this.multiplicity, 0, this.multiplicity));
    }

    @Override
    public void indexSubClassOfAxiom(ElkClassExpression subElkClass, ElkClassExpression superElkClass) {
        IndexedClassExpression subIndexedClass = subElkClass.accept(this.negativeIndexer);
        IndexedClassExpression superIndexedClass = superElkClass.accept(this.positiveIndexer);
        if (this.multiplicity == 1) {
            subIndexedClass.addToldSuperClassExpression(superIndexedClass);
        } else {
            subIndexedClass.removeToldSuperClassExpression(superIndexedClass);
        }
    }

    @Override
    public void indexClassAssertion(ElkIndividual individual, ElkClassExpression type) {
        IndexedClassExpression indexedIndividual = individual.accept(this.negativeIndexer);
        IndexedClassExpression indexedType = type.accept(this.positiveIndexer);
        if (this.multiplicity == 1) {
            indexedIndividual.addToldSuperClassExpression(indexedType);
        } else {
            indexedIndividual.removeToldSuperClassExpression(indexedType);
        }
    }

    @Override
    public void indexSubObjectPropertyOfAxiom(ElkSubObjectPropertyExpression subElkProperty, ElkObjectPropertyExpression superElkProperty) {
        IndexedPropertyChain subIndexedProperty = subElkProperty.accept(this.negativeIndexer);
        IndexedObjectProperty superIndexedProperty = (IndexedObjectProperty)superElkProperty.accept(this.positiveIndexer);
        if (this.multiplicity == 1) {
            subIndexedProperty.addToldSuperObjectProperty(superIndexedProperty);
            superIndexedProperty.addToldSubObjectProperty(subIndexedProperty);
        } else {
            subIndexedProperty.removeToldSuperObjectProperty(superIndexedProperty);
            superIndexedProperty.removeToldSubObjectProperty(subIndexedProperty);
        }
    }

    @Override
    public void indexDisjointClassExpressions(List<? extends ElkClassExpression> disjointClasses) {
        this.ontologyIndex.getIndexedOwlNothing().updateOccurrenceNumbers(this.multiplicity, this.multiplicity, 0);
        if (disjointClasses.size() == 2) {
            IndexedClassExpression ice0 = disjointClasses.get(0).accept(this.negativeIndexer);
            IndexedClassExpression ice1 = disjointClasses.get(1).accept(this.negativeIndexer);
            if (this.multiplicity == 1) {
                ice0.addDisjointClass(ice1);
                ice1.addDisjointClass(ice0);
            } else {
                ice0.removeDisjointClass(ice1);
                ice1.removeDisjointClass(ice0);
            }
        } else {
            ArrayList<IndexedClassExpression> indexed = new ArrayList<IndexedClassExpression>(disjointClasses.size());
            for (ElkClassExpression elkClassExpression : disjointClasses) {
                indexed.add(elkClassExpression.accept(this.negativeIndexer));
            }
            IndexedDisjointnessAxiom indexedDisjointnessAxiom = new IndexedDisjointnessAxiom(indexed);
            for (IndexedClassExpression ice : indexed) {
                if (this.multiplicity == 1) {
                    ice.addDisjointnessAxiom(indexedDisjointnessAxiom);
                    continue;
                }
                ice.removeDisjointnessAxiom(indexedDisjointnessAxiom);
            }
        }
    }

    @Override
    public void indexReflexiveObjectProperty(ElkObjectPropertyExpression reflexiveProperty) {
        IndexedObjectProperty indexedReflexiveProperty = (IndexedObjectProperty)reflexiveProperty.accept(this.positiveIndexer);
        if (this.multiplicity == 1) {
            this.ontologyIndex.addReflexiveObjectProperty(indexedReflexiveProperty);
        } else {
            this.ontologyIndex.removeReflexiveObjectProperty(indexedReflexiveProperty);
        }
    }

    @Override
    public IndexedClass indexClassDeclaration(ElkClass ec) {
        return (IndexedClass)ec.accept(this.neutralIndexer);
    }

    @Override
    public IndexedObjectProperty indexObjectPropertyDeclaration(ElkObjectProperty ep) {
        return (IndexedObjectProperty)ep.accept(this.neutralIndexer);
    }

    @Override
    public IndexedIndividual indexNamedIndividualDeclaration(ElkNamedIndividual eni) {
        return eni.accept(this.neutralIndexer);
    }

    @Override
    public void visit(ElkAxiom elkAxiom) {
        block3: {
            try {
                elkAxiom.accept(this);
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)("indexing " + OwlFunctionalStylePrinter.toString(elkAxiom) + " with multiplicity = " + this.multiplicity));
                }
            }
            catch (IndexingException e) {
                if (!LOGGER_.isEnabledFor((Priority)Level.WARN)) break block3;
                LOGGER_.warn((Object)new ElkMessage(e.getMessage() + " Axiom ignored:\n" + OwlFunctionalStylePrinter.toString(elkAxiom), "reasoner.indexing.axiomIgnored"));
            }
        }
    }

    private class UpdateCacheFilter
    implements IndexedObjectFilter {
        protected final int increment;
        protected final int positiveIncrement;
        protected final int negativeIncrement;

        UpdateCacheFilter(int increment, int positiveIncrement, int negativeIncrement) {
            this.increment = increment;
            this.positiveIncrement = positiveIncrement;
            this.negativeIncrement = negativeIncrement;
        }

        @Override
        public IndexedClassExpression filter(IndexedClassExpression ice) {
            IndexedClassExpression result = ElkAxiomIndexerVisitor.this.ontologyIndex.filter(ice);
            if (!result.occurs() && this.increment > 0) {
                ElkAxiomIndexerVisitor.this.ontologyIndex.add(result);
            }
            result.updateOccurrenceNumbers(this.increment, this.positiveIncrement, this.negativeIncrement);
            if (!result.occurs() && this.increment < 0) {
                ElkAxiomIndexerVisitor.this.ontologyIndex.remove(result);
            }
            return result;
        }

        @Override
        public IndexedPropertyChain filter(IndexedPropertyChain ipc) {
            IndexedPropertyChain result = ElkAxiomIndexerVisitor.this.ontologyIndex.filter(ipc);
            if (!result.occurs() && this.increment > 0) {
                ElkAxiomIndexerVisitor.this.ontologyIndex.add(result);
            }
            result.updateOccurrenceNumber(this.increment);
            if (!result.occurs() && this.increment < 0) {
                ElkAxiomIndexerVisitor.this.ontologyIndex.remove(result);
            }
            return result;
        }
    }
}

