/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.consistency;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.ReasonerComputation;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationFactory;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationJob;
import org.semanticweb.elk.reasoner.saturation.classes.ContextClassSaturation;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;

public class ConsistencyChecking
extends ReasonerComputation<SaturationJob<IndexedClassEntity>, ClassExpressionSaturationFactory.Engine, ClassExpressionSaturationFactory<SaturationJob<IndexedClassEntity>>> {
    private static final Logger LOGGER_ = Logger.getLogger(ConsistencyChecking.class);
    private final ConsistencyMonitor consistencyMonitor;

    ConsistencyChecking(Collection<SaturationJob<IndexedClassEntity>> inputJobs, ConsistencyMonitor consistencyMonitor, ClassExpressionSaturationFactory<SaturationJob<IndexedClassEntity>> saturationFactory, ComputationExecutor executor, int maxWorkers, ProgressMonitor progressMonitor) {
        super(inputJobs, saturationFactory, executor, maxWorkers, progressMonitor);
        this.consistencyMonitor = consistencyMonitor;
    }

    public ConsistencyChecking(Collection<IndexedClassEntity> inputEntities, ConsistencyMonitor consistencyMonitor, OntologyIndex ontologyIndex, ComputationExecutor executor, int maxWorkers, ProgressMonitor progressMonitor) {
        this(new TodoJobs(inputEntities, consistencyMonitor), consistencyMonitor, new ClassExpressionSaturationFactory<SaturationJob<IndexedClassEntity>>(ontologyIndex, maxWorkers, new ThisClassExpressionSaturationListener(consistencyMonitor)), executor, maxWorkers, progressMonitor);
    }

    public static Collection<IndexedClassEntity> getTestEntities(final OntologyIndex ontologyIndex) {
        if (!ontologyIndex.getIndexedOwlNothing().occursPositively()) {
            return Collections.emptySet();
        }
        return new AbstractCollection<IndexedClassEntity>(){

            @Override
            public Iterator<IndexedClassEntity> iterator() {
                return Operations.concat(Operations.singleton(ontologyIndex.getIndexedOwlThing()), ontologyIndex.getIndexedIndividuals()).iterator();
            }

            @Override
            public int size() {
                return ontologyIndex.getIndexedIndividuals().size() + 1;
            }
        };
    }

    public ConsistencyChecking(ComputationExecutor executor, int maxWorkers, ProgressMonitor progressMonitor, OntologyIndex ontologyIndex) {
        this(ConsistencyChecking.getTestEntities(ontologyIndex), new ConsistencyMonitor(), ontologyIndex, executor, maxWorkers, progressMonitor);
    }

    @Override
    public void process() {
        this.consistencyMonitor.registerCurrentThreadToInterrupt();
        super.process();
        this.consistencyMonitor.clearThreadToInterrupt();
    }

    public boolean isConsistent() {
        return !this.consistencyMonitor.isInconsistent();
    }

    public void printStatistics() {
        ((ClassExpressionSaturationFactory)this.inputProcessorFactory).printStatistics();
    }

    static class TodoJobs
    extends AbstractCollection<SaturationJob<IndexedClassEntity>>
    implements Collection<SaturationJob<IndexedClassEntity>> {
        private final Collection<IndexedClassEntity> inputs;
        private final ConsistencyMonitor consistencyMonitor;

        TodoJobs(Collection<IndexedClassEntity> inputs, ConsistencyMonitor consistenceMonitor) {
            this.inputs = inputs;
            this.consistencyMonitor = consistenceMonitor;
        }

        @Override
        public int size() {
            return this.inputs.size();
        }

        @Override
        public Iterator<SaturationJob<IndexedClassEntity>> iterator() {
            return new Iterator<SaturationJob<IndexedClassEntity>>(){
                final Iterator<IndexedClassEntity> inputsIterator;
                {
                    this.inputsIterator = TodoJobs.this.inputs.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (TodoJobs.this.consistencyMonitor.isInconsistent()) {
                        return false;
                    }
                    return this.inputsIterator.hasNext();
                }

                @Override
                public SaturationJob<IndexedClassEntity> next() {
                    if (TodoJobs.this.consistencyMonitor.isInconsistent()) {
                        throw new NoSuchElementException();
                    }
                    SaturationJob<IndexedClassExpression> job = new SaturationJob<IndexedClassExpression>(this.inputsIterator.next());
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)(job.getInput() + ": consistency checking submitted"));
                    }
                    return job;
                }

                @Override
                public void remove() {
                    this.inputsIterator.remove();
                }
            };
        }
    }

    static class ConsistencyMonitor {
        private volatile boolean inconsistent = false;
        private volatile Thread controlThread;

        ConsistencyMonitor() {
        }

        public void registerThreadToInterrupt(Thread controlThread) {
            this.controlThread = controlThread;
        }

        public void registerCurrentThreadToInterrupt() {
            this.registerThreadToInterrupt(Thread.currentThread());
        }

        public void clearThreadToInterrupt() {
            this.controlThread = null;
        }

        public boolean isInconsistent() {
            return this.inconsistent;
        }

        public void setInconsistent() {
            this.inconsistent = true;
            if (this.controlThread != null) {
                this.controlThread.interrupt();
            }
        }
    }

    private static class ThisClassExpressionSaturationListener
    implements ClassExpressionSaturationListener<SaturationJob<IndexedClassEntity>, ClassExpressionSaturationFactory.Engine> {
        private final ConsistencyMonitor consistenceMonitor;

        ThisClassExpressionSaturationListener(ConsistencyMonitor consistenceMonitor) {
            this.consistenceMonitor = consistenceMonitor;
        }

        @Override
        public void notifyFinished(SaturationJob<IndexedClassEntity> job) {
            if (!((ContextClassSaturation)job.getOutput()).isSatisfiable()) {
                this.consistenceMonitor.setInconsistent();
            }
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(job.getInput() + ": consistency checking finished: " + (((ContextClassSaturation)job.getOutput()).isSatisfiable() ? "satisfiable" : "unsatisfiable")));
            }
        }
    }
}

