/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.reasoner.DummyProgressMonitor;
import org.semanticweb.elk.reasoner.ElkFreshEntitiesException;
import org.semanticweb.elk.reasoner.ElkUnsupportedReasoningTaskException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.model.FreshInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.FreshTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.FreshTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;

public class Reasoner
extends AbstractReasonerState {
    private static final Logger LOGGER_ = Logger.getLogger(Reasoner.class);
    protected ProgressMonitor progressMonitor;
    protected final ReasonerStageExecutor stageExecutor;
    protected volatile ComputationExecutor executor;
    protected final int workerNo;
    protected boolean allowFreshEntities;

    protected Reasoner(ReasonerStageExecutor stageExecutor, ExecutorService executor, int workerNo) {
        this.stageExecutor = stageExecutor;
        this.workerNo = workerNo;
        this.progressMonitor = new DummyProgressMonitor();
        this.allowFreshEntities = true;
        this.reset();
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)"ELK reasoner was created");
        }
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void setAllowFreshEntities(boolean allow) {
        this.allowFreshEntities = allow;
    }

    public boolean getAllowFreshEntities() {
        return this.allowFreshEntities;
    }

    @Override
    protected int getNumberOfWorkers() {
        return this.workerNo;
    }

    @Override
    protected ComputationExecutor getProcessExecutor() {
        if (this.executor == null) {
            this.executor = new ComputationExecutor(this.workerNo, "elk-reasoner");
        }
        return this.executor;
    }

    @Override
    protected ReasonerStageExecutor getStageExecutor() {
        return this.stageExecutor;
    }

    @Override
    protected ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.reset();
        if (this.executor == null) {
            return true;
        }
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, unit);
        boolean success = this.executor.isShutdown();
        this.executor = null;
        if (success) {
            if (LOGGER_.isInfoEnabled()) {
                LOGGER_.info((Object)"ELK reasoner has shut down");
            }
        } else {
            LOGGER_.error((Object)"ELK reasoner failed to shut down!");
        }
        return success;
    }

    public boolean shutdown() throws InterruptedException {
        return this.shutdown(1L, TimeUnit.MINUTES);
    }

    protected TaxonomyNode<ElkClass> getTaxonomyNode(ElkClass elkClass) throws ElkException {
        TaxonomyNode<ElkClass> node = this.getTaxonomy().getNode(elkClass);
        if (node == null) {
            if (this.allowFreshEntities) {
                node = new FreshTaxonomyNode<ElkClass>(elkClass, this.getTaxonomy());
            } else {
                throw new ElkFreshEntitiesException(elkClass);
            }
        }
        return node;
    }

    protected InstanceNode<ElkClass, ElkNamedIndividual> getInstanceNode(ElkNamedIndividual elkNamedIndividual) throws ElkException {
        InstanceNode<ElkClass, ElkNamedIndividual> node = this.getInstanceTaxonomy().getInstanceNode(elkNamedIndividual);
        if (node == null) {
            if (this.allowFreshEntities) {
                node = new FreshInstanceNode<ElkClass, ElkNamedIndividual>(elkNamedIndividual, this.getInstanceTaxonomy());
            } else {
                throw new ElkFreshEntitiesException(elkNamedIndividual);
            }
        }
        return node;
    }

    protected TypeNode<ElkClass, ElkNamedIndividual> getTypeNode(ElkClass elkClass) throws ElkException {
        TypeNode<ElkClass, ElkNamedIndividual> node = this.getInstanceTaxonomy().getTypeNode(elkClass);
        if (node == null) {
            if (this.allowFreshEntities) {
                node = new FreshTypeNode<ElkClass, ElkNamedIndividual>(elkClass, this.getInstanceTaxonomy());
            } else {
                throw new ElkFreshEntitiesException(elkClass);
            }
        }
        return node;
    }

    public Node<ElkClass> getClassNode(ElkClass elkClass) throws ElkException {
        return this.getTaxonomyNode(elkClass);
    }

    public Set<? extends Node<ElkClass>> getSubClasses(ElkClassExpression classExpression, boolean direct) throws ElkException {
        if (classExpression instanceof ElkClass) {
            TaxonomyNode<ElkClass> node = this.getTaxonomyNode((ElkClass)classExpression);
            return direct ? node.getDirectSubNodes() : node.getAllSubNodes();
        }
        throw new ElkUnsupportedReasoningTaskException("ELK does not support computation of subclasses for complex class expressions.");
    }

    public Set<? extends Node<ElkClass>> getSuperClasses(ElkClassExpression classExpression, boolean direct) throws ElkException {
        if (classExpression instanceof ElkClass) {
            TaxonomyNode<ElkClass> node = this.getTaxonomyNode((ElkClass)classExpression);
            return direct ? node.getDirectSuperNodes() : node.getAllSuperNodes();
        }
        throw new ElkUnsupportedReasoningTaskException("ELK does not support computation of superclasses for complex class expressions.");
    }

    public Set<? extends Node<ElkNamedIndividual>> getInstances(ElkClassExpression classExpression, boolean direct) throws ElkException {
        if (classExpression instanceof ElkClass) {
            TypeNode<ElkClass, ElkNamedIndividual> node = this.getTypeNode((ElkClass)classExpression);
            return direct ? node.getDirectInstanceNodes() : node.getAllInstanceNodes();
        }
        throw new ElkUnsupportedReasoningTaskException("ELK does not support retrieval of instances for unnamed class expressions.");
    }

    public Set<? extends Node<ElkClass>> getTypes(ElkNamedIndividual elkNamedIndividual, boolean direct) throws ElkException {
        InstanceNode<ElkClass, ElkNamedIndividual> node = this.getInstanceNode(elkNamedIndividual);
        return direct ? node.getDirectTypeNodes() : node.getAllTypeNodes();
    }

    public boolean isSatisfiable(ElkClassExpression classExpression) throws ElkException {
        if (classExpression instanceof ElkClass) {
            Node<ElkClass> classNode = this.getClassNode((ElkClass)classExpression);
            return !classNode.getMembers().contains(PredefinedElkClass.OWL_NOTHING);
        }
        throw new ElkUnsupportedReasoningTaskException("ELK does not support satisfiability checking for unnamed class expressions");
    }
}

