/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.Loader;
import org.semanticweb.elk.loading.OntologyLoader;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owlapi.wrapper.OwlConverter;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class OwlOntologyLoader
implements OntologyLoader {
    private static final Logger LOGGER_ = Logger.getLogger(OwlOntologyLoader.class);
    private static final OwlConverter OWL_CONVERTER_ = OwlConverter.getInstance();
    private final OWLOntology owlOntology;
    private final ProgressMonitor progressMonitor;
    private String status;
    private Iterator<OWLOntology> importsClosureIterator;
    private int importsClosureCount;
    private int importsClosureProcessed;
    private Iterator<OWLAxiom> axiomsIterator;
    private int axiomsCount;
    private int axiomsProcessed;

    public OwlOntologyLoader(OWLOntology owlOntology, ProgressMonitor progressMonitor) {
        this.owlOntology = owlOntology;
        this.progressMonitor = progressMonitor;
        this.initImportsClosure();
    }

    @Override
    public Loader getLoader(final ElkAxiomProcessor axiomLoader) {
        return new Loader(){

            @Override
            public void load() {
                OwlOntologyLoader.this.progressMonitor.start(OwlOntologyLoader.this.status);
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)OwlOntologyLoader.this.status);
                }
                while (!Thread.currentThread().isInterrupted()) {
                    if (!OwlOntologyLoader.this.axiomsIterator.hasNext()) {
                        OwlOntologyLoader.this.importsClosureProcessed++;
                        if (!OwlOntologyLoader.this.importsClosureIterator.hasNext()) break;
                        OwlOntologyLoader.this.progressMonitor.finish();
                        OwlOntologyLoader.this.updateStatus();
                        OwlOntologyLoader.this.progressMonitor.start(OwlOntologyLoader.this.status);
                        if (LOGGER_.isTraceEnabled()) {
                            LOGGER_.trace((Object)OwlOntologyLoader.this.status);
                        }
                        OwlOntologyLoader.this.initAxioms((OWLOntology)OwlOntologyLoader.this.importsClosureIterator.next());
                    }
                    OWLAxiom axiom = (OWLAxiom)OwlOntologyLoader.this.axiomsIterator.next();
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)("loading " + axiom));
                    }
                    if (OWL_CONVERTER_.isRelevantAxiom(axiom)) {
                        axiomLoader.visit(OWL_CONVERTER_.convert(axiom));
                    }
                    OwlOntologyLoader.this.axiomsProcessed++;
                    OwlOntologyLoader.this.progressMonitor.report(OwlOntologyLoader.this.axiomsProcessed, OwlOntologyLoader.this.axiomsCount);
                }
                OwlOntologyLoader.this.progressMonitor.finish();
            }

            @Override
            public void dispose() {
                OwlOntologyLoader.this.dispose();
            }
        };
    }

    private void initImportsClosure() {
        Set importsClosure = this.owlOntology.getImportsClosure();
        this.importsClosureIterator = importsClosure.iterator();
        this.importsClosureCount = importsClosure.size();
        this.importsClosureProcessed = 0;
        this.updateStatus();
        if (this.importsClosureIterator.hasNext()) {
            this.initAxioms(this.importsClosureIterator.next());
        } else {
            this.axiomsIterator = Collections.emptySet().iterator();
        }
    }

    private void initAxioms(OWLOntology ontology) {
        Set axioms = ontology.getAxioms();
        this.axiomsIterator = axioms.iterator();
        this.axiomsCount = axioms.size();
        this.axiomsProcessed = 0;
    }

    private void updateStatus() {
        this.status = this.importsClosureCount == 1 ? "Loading" : "Loading " + (this.importsClosureProcessed + 1) + " of " + this.importsClosureCount;
    }

    private void dispose() {
        this.importsClosureIterator = null;
        this.importsClosureProcessed = 0;
        this.axiomsIterator = null;
        this.axiomsProcessed = 0;
    }
}

