/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.ChangesLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.loading.Loader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owlapi.wrapper.OwlConverter;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class OwlChangesLoader
implements ChangesLoader {
    private static final Logger LOGGER_ = Logger.getLogger(OwlChangesLoader.class);
    private static final OwlConverter OWL_CONVERTER_ = OwlConverter.getInstance();
    private final ProgressMonitor progressMonitor;
    protected final LinkedList<OWLOntologyChange> pendingChanges;

    OwlChangesLoader(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.pendingChanges = new LinkedList();
    }

    @Override
    public Loader getLoader(final ElkAxiomProcessor axiomInserter, final ElkAxiomProcessor axiomDeleter) {
        return new Loader(){

            @Override
            public void load() throws ElkLoadingException {
                if (!OwlChangesLoader.this.pendingChanges.isEmpty()) {
                    OWLOntologyChange change;
                    String status = "Loading of Changes";
                    OwlChangesLoader.this.progressMonitor.start(status);
                    int changesCount = OwlChangesLoader.this.pendingChanges.size();
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)(status + ": " + changesCount));
                    }
                    int currentAxiom = 0;
                    while (!Thread.currentThread().isInterrupted() && (change = (OWLOntologyChange)OwlChangesLoader.this.pendingChanges.poll()) != null) {
                        if (!change.isAxiomChange()) {
                            ElkLoadingException exception = new ElkLoadingException("Cannot apply non-axiom change!");
                            LOGGER_.error((Object)exception);
                            throw exception;
                        }
                        OWLAxiom owlAxiom = change.getAxiom();
                        ElkAxiom elkAxiom = OWL_CONVERTER_.convert(owlAxiom);
                        if (change instanceof AddAxiom) {
                            axiomInserter.visit(elkAxiom);
                            if (LOGGER_.isTraceEnabled()) {
                                LOGGER_.trace((Object)("adding " + owlAxiom));
                            }
                        } else if (change instanceof RemoveAxiom) {
                            axiomDeleter.visit(elkAxiom);
                            if (LOGGER_.isTraceEnabled()) {
                                LOGGER_.trace((Object)("removing " + owlAxiom));
                            }
                        } else {
                            throw new ElkLoadingException("Change type is not supported!");
                        }
                        OwlChangesLoader.this.progressMonitor.report(++currentAxiom, changesCount);
                    }
                    OwlChangesLoader.this.progressMonitor.finish();
                }
            }

            @Override
            public void dispose() {
            }
        };
    }

    void registerChange(OWLOntologyChange change) {
        this.pendingChanges.add(change);
    }

    Set<OWLAxiom> getPendingAxiomAdditions() {
        HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
        for (OWLOntologyChange change : this.pendingChanges) {
            if (!(change instanceof AddAxiom)) continue;
            added.add(change.getAxiom());
        }
        return added;
    }

    Set<OWLAxiom> getPendingAxiomRemovals() {
        HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
        for (OWLOntologyChange change : this.pendingChanges) {
            if (!(change instanceof RemoveAxiom)) continue;
            removed.add(change.getAxiom());
        }
        return removed;
    }

    List<OWLOntologyChange> getPendingChanges() {
        return this.pendingChanges;
    }
}

