/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class ElkReasonerProgressMonitor
implements ProgressMonitor {
    private final ReasonerProgressMonitor pm;
    private static final long updateInterval = 10L;
    private static final double mimimalIncrement = 0.005;
    private long lastUpdateTime;
    private double lastProgress;

    public ElkReasonerProgressMonitor(ReasonerProgressMonitor pm) {
        this.pm = pm;
    }

    @Override
    public void start(String message) {
        this.pm.reasonerTaskStarted(message);
        this.lastProgress = 0.0;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    @Override
    public void report(int state, int maxState) {
        long time = System.currentTimeMillis();
        double progress = maxState == 0 ? 0.0 : (double)state / (double)maxState;
        if (time > this.lastUpdateTime + 10L && progress > this.lastProgress + 0.005) {
            this.pm.reasonerTaskProgressChanged(state, maxState);
            this.lastUpdateTime = time;
            this.lastProgress = progress;
        }
    }

    @Override
    public void finish() {
        this.pm.reasonerTaskStopped();
    }
}

