/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;

public class ElkReasonerConfiguration
implements OWLReasonerConfiguration {
    private final ReasonerConfiguration elkConfig;
    private final OWLReasonerConfiguration owlConfig;

    public ElkReasonerConfiguration(OWLReasonerConfiguration owlConfig, ReasonerConfiguration elkConfig) {
        this.elkConfig = elkConfig;
        this.owlConfig = owlConfig;
    }

    public ElkReasonerConfiguration() {
        this(ElkReasonerConfiguration.getDefaultOwlReasonerConfiguration(null), ReasonerConfiguration.getConfiguration());
    }

    public ElkReasonerConfiguration(ReasonerProgressMonitor monitor) {
        this(ElkReasonerConfiguration.getDefaultOwlReasonerConfiguration(monitor), ReasonerConfiguration.getConfiguration());
    }

    public ElkReasonerConfiguration(OWLReasonerConfiguration genConfig) {
        this(genConfig, ReasonerConfiguration.getConfiguration());
    }

    public static OWLReasonerConfiguration getDefaultOwlReasonerConfiguration(ReasonerProgressMonitor monitor) {
        return new SimpleConfiguration(monitor, FreshEntityPolicy.ALLOW, 0L, IndividualNodeSetPolicy.BY_NAME);
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.owlConfig.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.owlConfig.getIndividualNodeSetPolicy();
    }

    public ReasonerProgressMonitor getProgressMonitor() {
        return this.owlConfig.getProgressMonitor();
    }

    public long getTimeOut() {
        return this.owlConfig.getTimeOut();
    }

    public ReasonerConfiguration getElkConfiguration() {
        return this.elkConfig;
    }
}

