/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owlapi.ElkConverter;
import org.semanticweb.elk.owlapi.ElkReasonerConfiguration;
import org.semanticweb.elk.owlapi.ElkReasonerProgressMonitor;
import org.semanticweb.elk.owlapi.OwlChangesLoader;
import org.semanticweb.elk.owlapi.OwlOntologyLoader;
import org.semanticweb.elk.owlapi.wrapper.OwlConverter;
import org.semanticweb.elk.reasoner.DummyProgressMonitor;
import org.semanticweb.elk.reasoner.ElkUnsupportedReasoningTaskException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasonerFactory;
import org.semanticweb.elk.reasoner.stages.LoggingStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.util.logging.ElkMessage;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.util.Version;

public class ElkReasoner
implements OWLReasoner {
    private static final Logger LOGGER_ = Logger.getLogger(ElkReasoner.class);
    private final OWLOntology owlOntology_;
    private final OWLOntologyManager owlOntologymanager_;
    private final Reasoner reasoner_;
    private final ProgressMonitor elkProgressMonitor_;
    private final boolean isBufferingMode_;
    private final OntologyChangeListener ontologyChangeListener_;
    private final ElkObjectFactory objectFactory_;
    private final OwlConverter owlConverter_;
    private final ElkConverter elkConverter_;
    private OwlChangesLoader ontologyChangesLoader_;
    private boolean ontologyReloadRequired_;

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ElkReasonerConfiguration elkConfig, ReasonerStageExecutor stageExecutor) {
        this.owlOntology_ = ontology;
        this.owlOntologymanager_ = ontology.getOWLOntologyManager();
        this.elkProgressMonitor_ = elkConfig.getProgressMonitor() == null ? new DummyProgressMonitor() : new ElkReasonerProgressMonitor(elkConfig.getProgressMonitor());
        this.reasoner_ = new ReasonerFactory().createReasoner(stageExecutor, elkConfig.getElkConfiguration());
        this.reasoner_.setAllowFreshEntities(elkConfig.getFreshEntityPolicy() == FreshEntityPolicy.ALLOW);
        this.reasoner_.setProgressMonitor(this.elkProgressMonitor_);
        this.isBufferingMode_ = isBufferingMode;
        this.ontologyChangeListener_ = new OntologyChangeListener();
        this.owlOntologymanager_.addOntologyChangeListener((OWLOntologyChangeListener)this.ontologyChangeListener_);
        this.objectFactory_ = new ElkObjectFactoryImpl();
        this.owlConverter_ = OwlConverter.getInstance();
        this.elkConverter_ = ElkConverter.getInstance();
        this.ontologyChangesLoader_ = new OwlChangesLoader(this.elkProgressMonitor_);
        this.reasoner_.registerOntologyLoader(new OwlOntologyLoader(this.owlOntology_, this.elkProgressMonitor_));
        this.reasoner_.registerOntologyChangesLoader(this.ontologyChangesLoader_);
        if (isBufferingMode) {
            try {
                this.reasoner_.loadOntology();
            }
            catch (ElkException e) {
                throw this.elkConverter_.convert(e);
            }
            this.ontologyReloadRequired_ = false;
        } else {
            this.ontologyReloadRequired_ = true;
        }
    }

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ElkReasonerConfiguration elkConfig) {
        this(ontology, isBufferingMode, elkConfig, new LoggingStageExecutor());
    }

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ReasonerStageExecutor stageExecutor, ReasonerProgressMonitor progressMonitor) {
        this(ontology, isBufferingMode, new ElkReasonerConfiguration(progressMonitor), stageExecutor);
    }

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ReasonerStageExecutor stageExecutor) {
        this(ontology, isBufferingMode, new ElkReasonerConfiguration(), stageExecutor);
    }

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode) {
        this(ontology, isBufferingMode, new ElkReasonerConfiguration(), new LoggingStageExecutor());
    }

    protected Reasoner getInternalReasoner() {
        return this.reasoner_;
    }

    private static UnsupportedOperationException unsupportedOwlApiMethod(String method) {
        String message = "OWL API reasoner method is not implemented: " + method + ".";
        LOGGER_.warn((Object)new ElkMessage(message, "owlapi.unsupportedMethod"));
        return new UnsupportedOperationException(message);
    }

    private static UnsupportedOperationException unsupportedOwlApiMethod(String method, String reason) {
        String message = "OWL API reasoner method is not fully implemented: " + method + ": " + reason;
        LOGGER_.warn((Object)new ElkMessage(message, "owlapi.unsupportedMethod"));
        return new UnsupportedOperationException(message);
    }

    private Node<OWLClass> getClassNode(ElkClass elkClass) throws FreshEntitiesException, InconsistentOntologyException, ElkException {
        try {
            return this.elkConverter_.convertClassNode(this.reasoner_.getClassNode(elkClass));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    private void checkInterrupted() throws ReasonerInterruptedException {
        if (this.reasoner_.isInterrupted()) {
            throw new ReasonerInterruptedException("ELK was interrupted");
        }
    }

    public void dispose() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"dispose()");
        }
        this.owlOntology_.getOWLOntologyManager().removeOntologyChangeListener((OWLOntologyChangeListener)this.ontologyChangeListener_);
        try {
            this.reasoner_.reset();
            while (true) {
                try {
                    if (!this.reasoner_.shutdown()) {
                        throw new ReasonerInternalException("Failed to shut down ELK!");
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public void flush() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"flush()");
        }
        this.checkInterrupted();
        try {
            if (this.ontologyReloadRequired_) {
                this.reasoner_.registerOntologyLoader(new OwlOntologyLoader(this.owlOntology_, this.elkProgressMonitor_));
                this.ontologyChangesLoader_ = new OwlChangesLoader(this.elkProgressMonitor_);
                this.reasoner_.loadOntology();
                this.ontologyReloadRequired_ = false;
            }
            this.reasoner_.registerOntologyChangesLoader(this.ontologyChangesLoader_);
            this.reasoner_.loadChanges();
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLClass> getBottomClassNode() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getBottomClassNode()");
        }
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlNothing());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getBottomClassNode()", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getBottomDataPropertyNode()");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getBottomDataPropertyNode()");
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getBottomObjectPropertyNode()");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getBottomObjectPropertyNode()");
    }

    public BufferingMode getBufferingMode() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getBufferingMode()");
        }
        return this.isBufferingMode_ ? BufferingMode.BUFFERING : BufferingMode.NON_BUFFERING;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getDataPropertyDomains(OWLDataProperty, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDataPropertyDomains(OWLDataProperty, boolean)");
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual arg0, OWLDataProperty arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getDataPropertyValues(OWLNamedIndividual, OWLDataProperty)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDataPropertyValues(OWLNamedIndividual, OWLDataProperty)");
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getDifferentIndividuals(OWLNamedIndividual)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDifferentIndividuals(OWLNamedIndividual)");
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression arg0) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getDisjointClasses(OWLClassExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointClasses(OWLClassExpression)");
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getDisjointDataProperties(OWLDataPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointDataProperties(OWLDataPropertyExpression)");
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getDisjointObjectProperties(OWLObjectPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointObjectProperties(OWLObjectPropertyExpression)");
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getEquivalentClasses(OWLClassExpression)");
        }
        this.checkInterrupted();
        if (ce.isAnonymous()) {
            throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentClasses(OWLClassExpression)", "Elk does not support computation of classes equivalent to unnamed class expressions");
        }
        try {
            return this.getClassNode(this.owlConverter_.convert(ce.asOWLClass()));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentClasses(OWLClassExpression)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getEquivalentDataProperties(OWLDataProperty)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentDataProperties(OWLDataProperty)");
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getEquivalentObjectProperties(OWLObjectPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentObjectProperties(OWLObjectPropertyExpression)");
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getFreshEntityPolicy()");
        }
        return this.reasoner_.getAllowFreshEntities() ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW;
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getIndividualNodeSetPolicy()");
        }
        return IndividualNodeSetPolicy.BY_NAME;
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getInstances(OWLClassExpression, boolean)");
        }
        this.checkInterrupted();
        try {
            return this.elkConverter_.convertIndividualNodes(this.reasoner_.getInstances(this.owlConverter_.convert(ce), direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getInstances(OWLClassExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getInverseObjectProperties(OWLObjectPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getInverseObjectProperties(OWLObjectPropertyExpression)");
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getObjectPropertyDomains(OWLObjectPropertyExpression, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyDomains(OWLObjectPropertyExpression, boolean)");
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getObjectPropertyRanges(OWLObjectPropertyExpression, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyRanges(OWLObjectPropertyExpression, boolean)");
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual arg0, OWLObjectPropertyExpression arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getObjectPropertyValues(OWLNamedIndividual, OWLObjectPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyValues(OWLNamedIndividual, OWLObjectPropertyExpression)");
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getPendingAxiomAdditions()");
        }
        return this.ontologyChangesLoader_.getPendingAxiomAdditions();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getPendingAxiomRemovals()");
        }
        return this.ontologyChangesLoader_.getPendingAxiomRemovals();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getPendingChanges()");
        }
        return this.ontologyChangesLoader_.getPendingChanges();
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getPrecomputableInferenceTypes()");
        }
        return new HashSet<InferenceType>(Arrays.asList(InferenceType.CLASS_ASSERTIONS, InferenceType.CLASS_HIERARCHY));
    }

    public String getReasonerName() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getReasonerName()");
        }
        return ElkReasoner.class.getPackage().getImplementationTitle();
    }

    public Version getReasonerVersion() {
        int filled;
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getReasonerVersion()");
        }
        String versionString = ElkReasoner.class.getPackage().getImplementationVersion();
        int[] version = new int[4];
        if (versionString != null) {
            String[] splitted = versionString.split("\\.");
            for (filled = 0; filled < splitted.length; ++filled) {
                version[filled] = Integer.parseInt(splitted[filled]);
            }
        }
        while (filled < version.length) {
            version[filled] = 0;
            ++filled;
        }
        return new Version(version[0], version[1], version[2], version[3]);
    }

    public OWLOntology getRootOntology() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getRootOntology()");
        }
        return this.owlOntology_;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getSameIndividuals(OWLNamedIndividual)");
        }
        this.checkInterrupted();
        return new OWLNamedIndividualNode(arg0);
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getSubClasses(OWLClassExpression, boolean)");
        }
        this.checkInterrupted();
        try {
            return this.elkConverter_.convertClassNodes(this.reasoner_.getSubClasses(this.owlConverter_.convert(ce), direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSubClasses(OWLClassExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getSubDataProperties(OWLDataProperty, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSubDataProperties(OWLDataProperty, boolean)");
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getSubObjectProperties(OWLObjectPropertyExpression, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSubObjectProperties(OWLObjectPropertyExpression, boolean)");
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getSuperClasses(OWLClassExpression, boolean)");
        }
        this.checkInterrupted();
        try {
            return this.elkConverter_.convertClassNodes(this.reasoner_.getSuperClasses(this.owlConverter_.convert(ce), direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSuperClasses(OWLClassExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getSuperDataProperties(OWLDataProperty, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSuperDataProperties(OWLDataProperty, boolean)");
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getSuperObjectProperties(OWLObjectPropertyExpression, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSuperObjectProperties(OWLObjectPropertyExpression, boolean)");
    }

    public long getTimeOut() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getTimeOut()");
        }
        return 0L;
    }

    public Node<OWLClass> getTopClassNode() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getTopClassNode()");
        }
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlThing());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTopClassNode()", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getTopDataPropertyNode()");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getTopDataPropertyNode()");
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getTopObjectPropertyNode()");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getTopObjectPropertyNode()");
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getTypes(OWLNamedIndividual, boolean)");
        }
        this.checkInterrupted();
        try {
            return this.elkConverter_.convertClassNodes(this.reasoner_.getTypes(this.owlConverter_.convert(ind), direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTypes(OWLNamedIndividual, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getUnsatisfiableClasses()");
        }
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlNothing());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getUnsatisfiableClasses()", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public void interrupt() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"interrupt()");
        }
        this.reasoner_.interrupt();
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"isConsistent()");
        }
        try {
            return this.reasoner_.isConsistent();
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isConsistent()", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public boolean isEntailed(OWLAxiom arg0) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"isEntailed(OWLAxiom)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("isEntailed(OWLAxiom)");
    }

    public boolean isEntailed(Set<? extends OWLAxiom> arg0) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"isEntailed(Set<? extends OWLAxiom>)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("isEntailed(Set<? extends OWLAxiom>)");
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> arg0) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"isEntailmentCheckingSupported(AxiomType<?>)");
        }
        return false;
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"isPrecomputed(InferenceType)");
        }
        if (inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) {
            return this.reasoner_.doneTaxonomy();
        }
        if (inferenceType.equals((Object)InferenceType.CLASS_ASSERTIONS)) {
            return this.reasoner_.doneInstanceTaxonomy();
        }
        return false;
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"isSatisfiable(OWLClassExpression)");
        }
        this.checkInterrupted();
        try {
            return this.reasoner_.isSatisfiable(this.owlConverter_.convert(classExpression));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isSatisfiable(classExpression)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"precomputeInferences(InferenceType...)");
        }
        this.checkInterrupted();
        try {
            for (InferenceType inferenceType : inferenceTypes) {
                if (inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) {
                    this.reasoner_.getTaxonomy();
                    continue;
                }
                if (!inferenceType.equals((Object)InferenceType.CLASS_ASSERTIONS)) continue;
                this.reasoner_.getInstanceTaxonomy();
            }
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("precomputeInferences(inferenceTypes)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    protected class OntologyChangeListener
    implements OWLOntologyChangeListener {
        protected OntologyChangeListener() {
        }

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            for (OWLOntologyChange oWLOntologyChange : changes) {
                if (!oWLOntologyChange.getOntology().equals(ElkReasoner.this.owlOntology_)) {
                    LOGGER_.warn((Object)"Ignoring the change not applicable to the current onttolgy: + change");
                    continue;
                }
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)("registring change: " + oWLOntologyChange));
                }
                ElkReasoner.this.ontologyChangesLoader_.registerChange(oWLOntologyChange);
                if (oWLOntologyChange.isAxiomChange()) continue;
                ElkReasoner.this.ontologyReloadRequired_ = true;
            }
            if (!ElkReasoner.this.isBufferingMode_) {
                ElkReasoner.this.flush();
            }
        }
    }
}

