/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.loading;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.loading.Loader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;

public class Owl2ParserLoader
implements Loader {
    private final Owl2Parser parser_;
    private final ElkAxiomProcessor axiomLoader_;
    private final BlockingQueue<ElkAxiom> axiomBuffer_;
    private final Thread parserThread_;
    private volatile Thread controlThread_;
    private volatile boolean started_;
    private volatile boolean finished_;
    private volatile boolean waiting_;
    protected volatile ElkLoadingException exception;

    public Owl2ParserLoader(Owl2Parser owlParser, ElkAxiomProcessor axiomLoader, int bufferSize) {
        this.parser_ = owlParser;
        this.axiomLoader_ = axiomLoader;
        this.axiomBuffer_ = new ArrayBlockingQueue<ElkAxiom>(bufferSize);
        this.finished_ = false;
        this.parserThread_ = new Thread((Runnable)new Parser(), "elk-parser-thread");
        this.started_ = false;
        this.exception = null;
    }

    public Owl2ParserLoader(Owl2Parser owlParser, ElkAxiomProcessor axiomLoader) {
        this(owlParser, axiomLoader, 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void load() throws ElkLoadingException {
        this.controlThread_ = Thread.currentThread();
        if (!this.started_) {
            this.parserThread_.start();
            this.started_ = true;
        }
        ElkAxiom axiom = null;
        this.waiting_ = true;
        try {
            while (!Thread.currentThread().isInterrupted()) {
                if (this.finished_) {
                    axiom = (ElkAxiom)this.axiomBuffer_.poll();
                } else {
                    try {
                        axiom = this.axiomBuffer_.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (axiom == null) {
                    break;
                }
                this.axiomLoader_.visit(axiom);
            }
        }
        finally {
            BlockingQueue<ElkAxiom> blockingQueue = this.axiomBuffer_;
            synchronized (blockingQueue) {
                this.waiting_ = false;
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    protected void disposeParserResources() {
    }

    @Override
    public void dispose() {
        if (!this.finished_) {
            this.parserThread_.interrupt();
        }
        this.disposeParserResources();
        this.axiomBuffer_.clear();
        this.exception = null;
    }

    private static class AxiomInserter
    implements Owl2ParserAxiomProcessor {
        private final BlockingQueue<ElkAxiom> axiomBuffer_;

        AxiomInserter(BlockingQueue<ElkAxiom> axiomBuffer) {
            this.axiomBuffer_ = axiomBuffer;
        }

        @Override
        public void visit(ElkAxiom elkAxiom) throws Owl2ParseException {
            try {
                this.axiomBuffer_.put(elkAxiom);
            }
            catch (InterruptedException e) {
                throw new Owl2ParseException("ELK Parser was interrupted", e);
            }
        }

        @Override
        public void visit(ElkPrefix elkPrefix) throws Owl2ParseException {
        }
    }

    private class Parser
    implements Runnable {
        private Parser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Owl2ParserLoader.this.parser_.accept(new AxiomInserter(Owl2ParserLoader.this.axiomBuffer_));
            }
            catch (Exception e) {
                Owl2ParserLoader.this.exception = new ElkLoadingException("Cannot load the ontology!", e);
            }
            finally {
                Owl2ParserLoader.this.finished_ = true;
                BlockingQueue blockingQueue = Owl2ParserLoader.this.axiomBuffer_;
                synchronized (blockingQueue) {
                    if (Owl2ParserLoader.this.waiting_) {
                        Owl2ParserLoader.this.controlThread_.interrupt();
                    }
                }
                Owl2ParserLoader.this.disposeParserResources();
            }
        }
    }
}

