/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.config.ConfigurationException;
import org.semanticweb.elk.config.Validator;

public class BaseConfiguration {
    private final Map<String, Validator> validators = new HashMap<String, Validator>();
    private final Map<String, String> paramMap = new HashMap<String, String>();

    public BaseConfiguration() {
    }

    protected BaseConfiguration(BaseConfiguration config) {
        this.paramMap.putAll(config.paramMap);
        this.validators.putAll(config.validators);
    }

    protected void initConfiguration() {
        Field[] allFields;
        for (Field field : allFields = this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Parameter.class)) continue;
            Parameter annotation = field.getAnnotation(Parameter.class);
            Class<?> paramClass = null;
            Validator validator = null;
            String paramValue = null;
            String paramName = null;
            try {
                paramClass = Class.forName(annotation.type());
                validator = new Validator(paramClass);
                paramName = field.get(null).toString();
                paramValue = validator.create(annotation.value()).toString();
            }
            catch (Exception e) {
                throw new ConfigurationException("Perhaps incorrect declaration of the configuration parameter " + field.getName(), e);
            }
            this.paramMap.put(paramName, paramValue);
            this.validators.put(paramName, validator);
        }
    }

    public String getParameter(String name) {
        return this.paramMap.get(name);
    }

    public int getParameterAsInt(String name) {
        return Integer.valueOf(this.paramMap.get(name));
    }

    public BaseConfiguration setParameter(String name, String value) {
        if (!this.validate(name, value)) {
            throw new ConfigurationException("Wrong value " + value + " for parameter " + name);
        }
        this.paramMap.put(name, value);
        return this;
    }

    private boolean validate(String name, String value) {
        Validator validator = this.validators.get(name);
        try {
            if (validator != null) {
                validator.create(value);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.paramMap.keySet());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameter {
        public String type();

        public String value() default "";
    }
}

