/* Generated By:JavaCC: Do not edit this line. AbstractOwl2FunctionalStyleParser.java */
package org.semanticweb.elk.owl.parsing.javacc;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

import org.semanticweb.elk.owl.interfaces.ElkAnnotation;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationProperty;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationSubject;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationValue;
import org.semanticweb.elk.owl.interfaces.ElkAnonymousIndividual;
import org.semanticweb.elk.owl.interfaces.ElkAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAsymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkDataComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkDataExactCardinality;
import org.semanticweb.elk.owl.interfaces.ElkDataHasValue;
import org.semanticweb.elk.owl.interfaces.ElkDataIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkDataMaxCardinality;
import org.semanticweb.elk.owl.interfaces.ElkDataMinCardinality;
import org.semanticweb.elk.owl.interfaces.ElkDataOneOf;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataRange;
import org.semanticweb.elk.owl.interfaces.ElkDataSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkDataUnionOf;
import org.semanticweb.elk.owl.interfaces.ElkDatatype;
import org.semanticweb.elk.owl.interfaces.ElkDatatypeDefinitionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDatatypeRestriction;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDifferentIndividualsAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointDataPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointUnionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentDataPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFacetRestriction;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalDataPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkHasKeyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkInverseObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIrreflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkLiteral;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNegativeDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectExactCardinality;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasSelf;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasValue;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectInverseOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectMaxCardinality;
import org.semanticweb.elk.owl.interfaces.ElkObjectMinCardinality;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectUnionOf;
import org.semanticweb.elk.owl.interfaces.ElkReflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubAnnotationPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubDataPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSWRLRule;
import org.semanticweb.elk.owl.iris.ElkAbbreviatedIri;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.iris.ElkPrefixDeclarations;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;

public abstract class AbstractOwl2FunctionalStyleParser implements Owl2Parser, AbstractOwl2FunctionalStyleParserConstants {

        /**
	 * Get prefix declarations to resolve IRIs.
	 */
        protected abstract ElkPrefixDeclarations getElkPrefixDeclarations();

        /**
	 * Get a factory used for creating of ELK Objects.
	 */
        protected abstract ElkObjectFactory getElkObjectFactory();

        @Override
        public void declarePrefix(ElkPrefix prefix) {
                getElkPrefixDeclarations().addPrefix(prefix);
        }

        @Override
        public void accept(Owl2ParserAxiomProcessor axiomProcessor)
                                throws Owl2ParseException {
                try {
                        ontologyDocument(axiomProcessor);
                } catch (ParseException e) {
                        throw new Owl2ParseException("Cannot parse the ontology!", e);
                } finally {
                        axiomProcessor.finish();
                }
        }

/*------------------------------------------------------------------
 * PARSER RULES
 *------------------------------------------------------------------*/

/* 2 Preliminary Definitions */

/* 2.3 Integers, Characters, Strings, Language Tags, and Node IDs */
/* @ (U+40) followed a nonempty sequence of characters matching the
* langtag production from [BCP 47]
*/
  final public String languageTag() throws ParseException {
        Token t;
    t = jj_consume_token(LANGTAG);
                {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

/* See LANGTAG in [SPARQL] */
/* a finite sequence of characters matching the BLANK_NODE_LABEL
* production of [SPARQL]
*/
  final public String nodeId() throws ParseException {
        Token t;
    t = jj_consume_token(BLANK_NODE_PREFIX);
    jj_consume_token(PN_LOCAL);
                {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

/* 2.3 IRIs */
/* An iri as defined in [RFC3987], enclosed in a pair of < (U+3C) and >
* (U+3E) characters. See IRI_REF in [SPARQL].
* The function returns only the IRI part of the string without the
* enclosing < >.
*/
  final public ElkFullIri fullIri() throws ParseException {
        Token t;
    t = jj_consume_token(FULL_IRI);
                {if (true) return new ElkFullIri(t.image);}
    throw new Error("Missing return statement in function");
  }

/* Extract the actual IRI from a full IRI or abbreviated IRI */
  final public ElkIri iri() throws ParseException {
        ElkIri x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FULL_IRI:
      x = fullIri();
      break;
    case PNAME_NS:
      x = abbreviatedIri();
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/* 
* A finite sequence of characters matching the PNAME_LN production of
* [SPARQL]. The function returns the IRI that the abbreviation encodes
* based on the known prefix declarations.
*/
  final public ElkAbbreviatedIri abbreviatedIri() throws ParseException {
        String prefixName;
        ElkPrefix prefix;
        Token t;
    prefixName = prefixName();
    t = jj_consume_token(PN_LOCAL);
                prefix = getElkPrefixDeclarations().getPrefix(prefixName);
                if ( prefix != null ) {
                        {if (true) return new ElkAbbreviatedIri(prefix, t.image);}
                } else {
                        {if (true) throw new ParseException("Unknown prefix " + prefixName + ".");}
                }
    throw new Error("Missing return statement in function");
  }

/* a finite sequence of characters matching the as PNAME_NS production of
* [SPARQL]
*/
  final public String prefixName() throws ParseException {
        Token t = null;
    t = jj_consume_token(PNAME_NS);
                {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

/* 3 Ontologies */

/* 3.5 Ontology Annotations */
  final public void ontologyAnnotations() throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANNOTATION:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      annotation();
    }
  }

/* 3.7 Functional-Style Syntax */
  final public void ontologyDocument(Owl2ParserAxiomProcessor axiomProcessor) throws ParseException, Owl2ParseException {
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PREFIX:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      prefixDeclaration(axiomProcessor);
    }
    ontology(axiomProcessor);
  }

  final public void prefixDeclaration(Owl2ParserAxiomProcessor axiomProcessor) throws ParseException, Owl2ParseException {
        String name;
        ElkFullIri iri;
    jj_consume_token(PREFIX);
    jj_consume_token(OPEN_BRACKET);
    name = prefixName();
    jj_consume_token(EQUALS);
    iri = fullIri();
    jj_consume_token(CLOSE_BRACKET);
                ElkPrefix prefix = new ElkPrefix(name, iri);

                if ( !getElkPrefixDeclarations().addPrefix( prefix ) ) {
                        {if (true) throw new ParseException("Duplicate declaration of prefix " + name + ".");}
                }

                axiomProcessor.visit(prefix);
  }

  final public void ontology(Owl2ParserAxiomProcessor axiomProcessor) throws ParseException, Owl2ParseException {
    jj_consume_token(ONTOLOGY);
    jj_consume_token(OPEN_BRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PNAME_NS:
    case FULL_IRI:
      ontologyIri();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PNAME_NS:
      case FULL_IRI:
        versionIri();
        break;
      default:
        jj_la1[3] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    directlyImportsDocuments();
    ontologyAnnotations();
    axioms(axiomProcessor);
    jj_consume_token(CLOSE_BRACKET);
  }

  final public ElkIri ontologyIri() throws ParseException {
        ElkIri x;
    x = iri();
                    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ElkIri versionIri() throws ParseException {
        ElkIri x;
    x = iri();
                    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public void directlyImportsDocuments() throws ParseException {
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      jj_consume_token(IMPORT);
      jj_consume_token(OPEN_BRACKET);
      iri();
      jj_consume_token(CLOSE_BRACKET);
    }
  }

  final public void axioms(Owl2ParserAxiomProcessor axiomProcessor) throws ParseException, Owl2ParseException {
        ElkAxiom x;
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECLARATION:
      case SUB_CLASS_OF:
      case EQUIVALENT_CLASSES:
      case DISJOINT_CLASSES:
      case DISJOINT_UNION:
      case SUB_OBJECT_PROPERTY_OF:
      case EQUIVALENT_OBJECT_PROPERTIES:
      case DISJOINT_OBJECT_PROPERTIES:
      case OBJECT_PROPERTY_DOMAIN:
      case OBJECT_PROPERTY_RANGE:
      case INVERSE_OBJECT_PROPERTIES:
      case FUNCTIONAL_OBJECT_PROPERTY:
      case INVERSE_FUNCTIONAL_OBJECT_PROPERTY:
      case REFLEXIVE_OBJECT_PROPERTY:
      case IRREFLEXIVE_OBJECT_PROPERTY:
      case SYMMETRIC_OBJECT_PROPERTY:
      case ASYMMETRIC_OBJECT_PROPERTY:
      case TRANSITIVE_OBJECT_PROPERTY:
      case SUB_DATA_PROPERTY_OF:
      case EQUIVALENT_DATA_PROPERTIES:
      case DISJOINT_DATA_PROPERTIES:
      case DATA_PROPERTY_DOMAIN:
      case DATA_PROPERTY_RANGE:
      case FUNCTIONAL_DATA_PROPERTY:
      case DATATYPE_DEFINITION:
      case HAS_KEY:
      case SWRL_RULE:
      case SAME_INDIVIDUAL:
      case DIFFERENT_INDIVIDUALS:
      case CLASS_ASSERTION:
      case OBJECT_PROPERTY_ASSERTION:
      case NEGATIVE_OBJECT_PROPERTY_ASSERTION:
      case DATA_PROPERTY_ASSERTION:
      case NEGATIVE_DATA_PROPERTY_ASSERTION:
      case ANNOTATION_ASSERTION:
      case SUB_ANNOTATION_PROPERTY_OF:
      case ANNOTATION_PROPERTY_DOMAIN:
      case ANNOTATION_PROPERTY_RANGE:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      x = axiom();
                        axiomProcessor.visit(x);
    }
  }

/* 4 Datatype Maps */

/* 4.1 Real Numbers, Decimal Numbers, and Integers */
// void dtRealsDecimalsIntegers():
// {}{
// 	<OWL_REAL>
// 	| <OWL_RATIONAL>
// 	| <XSD_DECIMAL>
// 	| <XSD_INTEGER>
// 	| <XSD_NON_NEGATIVE_INTEGER>
// 	| <XSD_NON_POSITIVE_INTEGER>
// 	| <XSD_POSITIVE_INTEGER>
// 	| <XSD_NEGATIVE_INTEGER>
// 	| <XSD_LONG>
// 	| <XSD_INT>
// 	| <XSD_SHORT>
// 	| <XSD_BYTE>
// 	| <XSD_UNSIGNED_LONG>
// 	| <XSD_UNSIGNED_INT>
// 	| <XSD_UNSIGNED_SHORT>
// 	| <XSD_UNSIGNED_BYTE>
// }

/* 4.2 Floating-Point Numbers */
// void dtFloats():
// {}{
// 	<XSD_DOUBLE>
// 	| <XSD_FLOAT>
// }
/* 4.3 Strings */
// void dtStrings():
// {}{
// 	<RDF_PLAIN_LITERAL>
// 	| <XSD_STRING>
// 	| <XSD_NORMALIZED_STRING>
// 	| <XSD_TOKEN>
// 	| <XSD_LANGUAGE>
// 	| <XSD_NAME>
// 	| <XSD_NC_NAME>
// 	| <XSD_NMTOKEN>
// }

/* 4.4 Boolean Values */
// void dtBooleans():
// {}{
// 	<XSD_BOOLEAN>
// }

/* 4.5 Binary Data */
// void dtBinaryData():
// {}{
// 	<XSD_HEX_BINARY>
// 	| <XSD_BASE_64_BINARY>
// }

/* 4.6 IRIs */
// void dtIris():
// {}{
// 	<XSD_ANY_URI>
// }

/* 4.7 Time Instants */
// void dtTimeInstants():
// {}{
// 	<XSD_DATE_TIME_STAMP>
// }

/* 4.8 XML Literals */
// void dtXmlLiterals():
// {}{
// 	<RDF_XML_LITERAL>
// }


/* 5 Entities and Literals */

/* 5.1 Classes */
  final public ElkClass clazz() throws ParseException {
        ElkIri x;
    x = iri();
                    {if (true) return getElkObjectFactory().getClass(x);}
    throw new Error("Missing return statement in function");
  }

/* 5.2 Datatypes */
  final public ElkDatatype datatype() throws ParseException {
        ElkIri x;
    x = iri();
                {if (true) return getElkObjectFactory().getDatatype(x);}
    throw new Error("Missing return statement in function");
  }

/* 5.3 Object Properties */
  final public ElkObjectProperty objectProperty() throws ParseException {
        ElkIri x;
    x = iri();
                {if (true) return getElkObjectFactory().getObjectProperty(x);}
    throw new Error("Missing return statement in function");
  }

/* 5.4 Data Properties */
  final public ElkDataProperty dataProperty() throws ParseException {
        ElkIri x;
    x = iri();
                {if (true) return getElkObjectFactory().getDataProperty(x);}
    throw new Error("Missing return statement in function");
  }

/* 5.5 Annotation Properties */
  final public ElkAnnotationProperty annotationProperty() throws ParseException {
        ElkIri x;
    x = iri();
                {if (true) return getElkObjectFactory().getAnnotationProperty(x);}
    throw new Error("Missing return statement in function");
  }

/* 5.6 Individuals */
  final public ElkIndividual individual() throws ParseException {
        ElkIndividual x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PNAME_NS:
    case FULL_IRI:
      x = namedIndividual();
      break;
    case BLANK_NODE_PREFIX:
      x = anonymousIndividual();
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/* 5.6.1 Named Individuals */
  final public ElkNamedIndividual namedIndividual() throws ParseException {
        ElkIri x;
    x = iri();
                {if (true) return getElkObjectFactory().getNamedIndividual(x);}
    throw new Error("Missing return statement in function");
  }

/* 5.6.2 Anonymous Individuals */
  final public ElkAnonymousIndividual anonymousIndividual() throws ParseException {
        String x;
    /* TODO: something is needed to prevent node IDs to cross-refer between ontologies. */
            x = nodeId();
                {if (true) return getElkObjectFactory().getAnonymousIndividual(x);}
    throw new Error("Missing return statement in function");
  }

/* 5.7 Literals */
  final public ElkLiteral literal() throws ParseException {
        Token t;
        String lexform;
        String langtag = null;
        ElkDatatype d = null;
    lexform = quotedString();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REFERENCE:
      jj_consume_token(REFERENCE);
      d = datatype();
      break;
    default:
      jj_la1[9] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LANGTAG:
        langtag = languageTag();
        break;
      default:
        jj_la1[8] = jj_gen;
        ;
      }
    }
                if ( d == null ) {
                        d = getElkObjectFactory().getDatatypeRdfPlainLiteral();
                        if ( langtag == null ) {
                                lexform = lexform + "@";
                        } else {
                                lexform = lexform + langtag;
                        }
                }
                {if (true) return getElkObjectFactory().getLiteral(lexform, d);}
    throw new Error("Missing return statement in function");
  }

/* Retrieve the content of a quoted string. */
  final public String quotedString() throws ParseException {
        Token t;
    t = jj_consume_token(QUOTED_STRING);
                {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

/* 5.8 Entity Declarations and Typing */
  final public ElkDeclarationAxiom declaration() throws ParseException {
        ElkEntity x;
    jj_consume_token(DECLARATION);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = entity();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDeclarationAxiom(x);}
    throw new Error("Missing return statement in function");
  }

  final public ElkEntity entity() throws ParseException {
  ElkEntity x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASS:
      jj_consume_token(CLASS);
      jj_consume_token(OPEN_BRACKET);
      x = clazz();
      jj_consume_token(CLOSE_BRACKET);
      break;
    case DATATYPE:
      jj_consume_token(DATATYPE);
      jj_consume_token(OPEN_BRACKET);
      x = datatype();
      jj_consume_token(CLOSE_BRACKET);
      break;
    case OBJECT_PROPERTY:
      jj_consume_token(OBJECT_PROPERTY);
      jj_consume_token(OPEN_BRACKET);
      x = objectProperty();
      jj_consume_token(CLOSE_BRACKET);
      break;
    case DATA_PROPERTY:
      jj_consume_token(DATA_PROPERTY);
      jj_consume_token(OPEN_BRACKET);
      x = dataProperty();
      jj_consume_token(CLOSE_BRACKET);
      break;
    case ANNOTATION_PROPERTY:
      jj_consume_token(ANNOTATION_PROPERTY);
      jj_consume_token(OPEN_BRACKET);
      x = annotationProperty();
      jj_consume_token(CLOSE_BRACKET);
      break;
    case NAMED_INDIVIDUAL:
      jj_consume_token(NAMED_INDIVIDUAL);
      jj_consume_token(OPEN_BRACKET);
      x = namedIndividual();
      jj_consume_token(CLOSE_BRACKET);
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
       {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/* 6 Property Expressions */
  final public ElkObjectPropertyExpression objectPropertyExpression() throws ParseException {
        ElkObjectPropertyExpression x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PNAME_NS:
    case FULL_IRI:
      x = objectProperty();
      break;
    case OBJECT_INVERSE_OF:
      x = inverseObjectProperty();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public void addObjectPropertyExpression(Collection<ElkObjectPropertyExpression> opexprs) throws ParseException {
        ElkObjectPropertyExpression x;
    x = objectPropertyExpression();
            opexprs.add(x);
  }

/* 6.1.1 Inverse Object Properties */
  final public ElkObjectInverseOf inverseObjectProperty() throws ParseException {
        ElkObjectProperty x;
    jj_consume_token(OBJECT_INVERSE_OF);
    jj_consume_token(OPEN_BRACKET);
    x = objectProperty();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectInverseOf(x);}
    throw new Error("Missing return statement in function");
  }

/* 6.2 Data Property Expressions */
  final public ElkDataPropertyExpression dataPropertyExpression() throws ParseException {
        ElkDataPropertyExpression x;
    x = dataProperty();
                             {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public void addDataPropertyExpression(Collection<ElkDataPropertyExpression> dpexprs) throws ParseException {
        ElkDataPropertyExpression x;
    x = dataProperty();
                             dpexprs.add(x);
  }

/* 7 Data Ranges */
  final public ElkDataRange dataRange() throws ParseException {
        ElkDataRange x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PNAME_NS:
    case FULL_IRI:
      x = datatype();
      break;
    case DATA_INTERSECTION_OF:
      x = dataIntersectionOf();
      break;
    case DATA_UNION_OF:
      x = dataUnionOf();
      break;
    case DATA_COMPLEMENT_OF:
      x = dataComplementOf();
      break;
    case DATA_ONE_OF:
      x = dataOneOf();
      break;
    case DATATYPE_RESTRICTION:
      x = datatypeRestriction();
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public Vector<ElkDataRange> dataRangeList() throws ParseException {
        ElkDataRange x;
        Vector<ElkDataRange> v =
                new Vector<ElkDataRange> ();
    x = dataRange();
                          v.add(x);
    label_5:
    while (true) {
      x = dataRange();
                            v.add(x);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATATYPE_RESTRICTION:
      case DATA_INTERSECTION_OF:
      case DATA_UNION_OF:
      case DATA_COMPLEMENT_OF:
      case DATA_ONE_OF:
      case PNAME_NS:
      case FULL_IRI:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_5;
      }
    }
          {if (true) return v;}
    throw new Error("Missing return statement in function");
  }

/* 7.1 Intersection of Data Ranges */
  final public ElkDataIntersectionOf dataIntersectionOf() throws ParseException {
        Vector<ElkDataRange> v;
    jj_consume_token(DATA_INTERSECTION_OF);
    jj_consume_token(OPEN_BRACKET);
    v = dataRangeList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDataIntersectionOf(v);}
    throw new Error("Missing return statement in function");
  }

/* 7.2 Union of Data Ranges */
  final public ElkDataUnionOf dataUnionOf() throws ParseException {
        Vector<ElkDataRange> v;
    jj_consume_token(DATA_UNION_OF);
    jj_consume_token(OPEN_BRACKET);
    v = dataRangeList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDataUnionOf(v);}
    throw new Error("Missing return statement in function");
  }

/* 7.3 Complement of Data Ranges */
  final public ElkDataComplementOf dataComplementOf() throws ParseException {
        ElkDataRange x;
    jj_consume_token(DATA_COMPLEMENT_OF);
    jj_consume_token(OPEN_BRACKET);
    x = dataRange();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDataComplementOf(x);}
    throw new Error("Missing return statement in function");
  }

/* 7.4 Enumeration of Literals */
  final public ElkDataOneOf dataOneOf() throws ParseException {
        ElkLiteral x;
        Vector<ElkLiteral> v =
                new Vector<ElkLiteral> ();
    jj_consume_token(DATA_ONE_OF);
    jj_consume_token(OPEN_BRACKET);
    x = literal();
                                v.add(x);
    label_6:
    while (true) {
      x = literal();
                                  v.add(x);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case QUOTED_STRING:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_6;
      }
    }
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDataOneOf(v);}
    throw new Error("Missing return statement in function");
  }

/* 7.5 Datatype Restrictions */
  final public ElkDatatypeRestriction datatypeRestriction() throws ParseException {
        ElkDatatype x;
        Vector<ElkFacetRestriction> v = new Vector<ElkFacetRestriction>();
    jj_consume_token(DATATYPE_RESTRICTION);
    jj_consume_token(OPEN_BRACKET);
    x = datatype();
    label_7:
    while (true) {
      addFacetRestriction(v);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PNAME_NS:
      case FULL_IRI:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_7;
      }
    }
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDatatypeRestriction(x,v);}
    throw new Error("Missing return statement in function");
  }

  final public void addFacetRestriction(Collection<ElkFacetRestriction> facetRestrs) throws ParseException {
        ElkIri restrIRI = null;
        ElkLiteral literal = null;
    restrIRI = iri();
    literal = literal();
                facetRestrs.add(getElkObjectFactory().getFacetRestriction(restrIRI, literal));
  }

/* 8 Class Expressions */
  final public ElkClassExpression classExpression() throws ParseException {
        ElkClassExpression x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PNAME_NS:
    case FULL_IRI:
      x = clazz();
      break;
    case OBJECT_INTERSECTION_OF:
      x = objectIntersectionOf();
      break;
    case OBJECT_UNION_OF:
      x = objectUnionOf();
      break;
    case OBJECT_COMPLEMENT_OF:
      x = objectComplementOf();
      break;
    case OBJECT_ONE_OF:
      x = objectOneOf();
      break;
    case OBJECT_SOME_VALUES_FROM:
      x = objectSomeValuesFrom();
      break;
    case OBJECT_ALL_VALUES_FROM:
      x = objectAllValuesFrom();
      break;
    case OBJECT_HAS_VALUE:
      x = objectHasValue();
      break;
    case OBJECT_HAS_SELF:
      x = objectHasSelf();
      break;
    case OBJECT_MIN_CARDINALITY:
      x = objectMinCardinality();
      break;
    case OBJECT_MAX_CARDINALITY:
      x = objectMaxCardinality();
      break;
    case OBJECT_EXACT_CARDINALITY:
      x = objectExactCardinality();
      break;
    case DATA_SOME_VALUES_FROM:
      x = dataSomeValuesFrom();
      break;
    case DATA_ALL_VALUES_FROM:
      x = dataAllValuesFrom();
      break;
    case DATA_HAS_VALUE:
      x = dataHasValue();
      break;
    case DATA_MIN_CARDINALITY:
      x = dataMinCardinality();
      break;
    case DATA_MAX_CARDINALITY:
      x = dataMaxCardinality();
      break;
    case DATA_EXACT_CARDINALITY:
      x = dataExactCardinality();
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
       {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/* 8.1 Propositional Connectives and Enumeration of Individuals */

/* 8.1.1 Intersection of Class Expressions */
  final public ElkObjectIntersectionOf objectIntersectionOf() throws ParseException {
        Vector<ElkClassExpression> v;
    jj_consume_token(OBJECT_INTERSECTION_OF);
    jj_consume_token(OPEN_BRACKET);
    v = classExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectIntersectionOf(v);}
    throw new Error("Missing return statement in function");
  }

/* 8.1.2 Union of Class Expressions */
  final public ElkObjectUnionOf objectUnionOf() throws ParseException {
        Vector<ElkClassExpression> v;
    jj_consume_token(OBJECT_UNION_OF);
    jj_consume_token(OPEN_BRACKET);
    v = classExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectUnionOf(v);}
    throw new Error("Missing return statement in function");
  }

/* 8.1.3 Complement of Class Expressions */
  final public ElkObjectComplementOf objectComplementOf() throws ParseException {
        ElkClassExpression x;
    jj_consume_token(OBJECT_COMPLEMENT_OF);
    jj_consume_token(OPEN_BRACKET);
    x = classExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectComplementOf(x);}
    throw new Error("Missing return statement in function");
  }

/* 8.1.4 Enumeration of Individuals */
  final public ElkObjectOneOf objectOneOf() throws ParseException {
        ElkIndividual x;
        Vector<ElkIndividual> v =
                new Vector<ElkIndividual> ();
    jj_consume_token(OBJECT_ONE_OF);
    jj_consume_token(OPEN_BRACKET);
    label_8:
    while (true) {
      x = individual();
                                     v.add(x);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PNAME_NS:
      case BLANK_NODE_PREFIX:
      case FULL_IRI:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_8;
      }
    }
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectOneOf(v);}
    throw new Error("Missing return statement in function");
  }

/* 8.2 Object Property Restrictions */

/* 8.2.1 Existential Quantification */
  final public ElkObjectSomeValuesFrom objectSomeValuesFrom() throws ParseException {
        ElkObjectPropertyExpression x;
        ElkClassExpression y;
    jj_consume_token(OBJECT_SOME_VALUES_FROM);
    jj_consume_token(OPEN_BRACKET);
    x = objectPropertyExpression();
    y = classExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectSomeValuesFrom(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 8.2.2 Universal Quantification */
  final public ElkObjectAllValuesFrom objectAllValuesFrom() throws ParseException {
        ElkObjectPropertyExpression x;
        ElkClassExpression y;
    jj_consume_token(OBJECT_ALL_VALUES_FROM);
    jj_consume_token(OPEN_BRACKET);
    x = objectPropertyExpression();
    y = classExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectAllValuesFrom(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 8.2.3 Individual Value Restriction */
  final public ElkObjectHasValue objectHasValue() throws ParseException {
        ElkObjectPropertyExpression x;
        ElkIndividual y;
    jj_consume_token(OBJECT_HAS_VALUE);
    jj_consume_token(OPEN_BRACKET);
    x = objectPropertyExpression();
    y = individual();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectHasValue(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 8.2.4 Self-Restriction */
  final public ElkObjectHasSelf objectHasSelf() throws ParseException {
        ElkObjectPropertyExpression x;
    jj_consume_token(OBJECT_HAS_SELF);
    jj_consume_token(OPEN_BRACKET);
    x = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectHasSelf(x);}
    throw new Error("Missing return statement in function");
  }

/* 8.3 Object Property Cardinality Restrictions */

/* 8.3.1 Minimum Cardinality */
  final public ElkObjectMinCardinality objectMinCardinality() throws ParseException {
        Token n;
        ElkObjectPropertyExpression x;
        ElkClassExpression y = null;
    jj_consume_token(OBJECT_MIN_CARDINALITY);
    jj_consume_token(OPEN_BRACKET);
    n = jj_consume_token(NON_NEGATIVE_INTEGER);
    x = objectPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OBJECT_INTERSECTION_OF:
    case OBJECT_UNION_OF:
    case OBJECT_COMPLEMENT_OF:
    case OBJECT_ONE_OF:
    case OBJECT_SOME_VALUES_FROM:
    case OBJECT_ALL_VALUES_FROM:
    case OBJECT_HAS_VALUE:
    case OBJECT_HAS_SELF:
    case OBJECT_MIN_CARDINALITY:
    case OBJECT_MAX_CARDINALITY:
    case OBJECT_EXACT_CARDINALITY:
    case DATA_SOME_VALUES_FROM:
    case DATA_ALL_VALUES_FROM:
    case DATA_HAS_VALUE:
    case DATA_MIN_CARDINALITY:
    case DATA_MAX_CARDINALITY:
    case DATA_EXACT_CARDINALITY:
    case PNAME_NS:
    case FULL_IRI:
      y = classExpression();
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
                if (y == null)
                        {if (true) return getElkObjectFactory().getObjectMinCardinality(x, Integer.parseInt( n.image ));}
                else
                        {if (true) return getElkObjectFactory().getObjectMinCardinalityQualified(x, Integer.parseInt( n.image ), y);}
    throw new Error("Missing return statement in function");
  }

/* 8.3.2 Maximum Cardinality */
  final public ElkObjectMaxCardinality objectMaxCardinality() throws ParseException {
        Token n;
        ElkObjectPropertyExpression x;
        ElkClassExpression y = null;
    jj_consume_token(OBJECT_MAX_CARDINALITY);
    jj_consume_token(OPEN_BRACKET);
    n = jj_consume_token(NON_NEGATIVE_INTEGER);
    x = objectPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OBJECT_INTERSECTION_OF:
    case OBJECT_UNION_OF:
    case OBJECT_COMPLEMENT_OF:
    case OBJECT_ONE_OF:
    case OBJECT_SOME_VALUES_FROM:
    case OBJECT_ALL_VALUES_FROM:
    case OBJECT_HAS_VALUE:
    case OBJECT_HAS_SELF:
    case OBJECT_MIN_CARDINALITY:
    case OBJECT_MAX_CARDINALITY:
    case OBJECT_EXACT_CARDINALITY:
    case DATA_SOME_VALUES_FROM:
    case DATA_ALL_VALUES_FROM:
    case DATA_HAS_VALUE:
    case DATA_MIN_CARDINALITY:
    case DATA_MAX_CARDINALITY:
    case DATA_EXACT_CARDINALITY:
    case PNAME_NS:
    case FULL_IRI:
      y = classExpression();
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
                if (y == null)
                        {if (true) return getElkObjectFactory().getObjectMaxCardinality(x, Integer.parseInt( n.image ));}
                else
                        {if (true) return getElkObjectFactory().getObjectMaxCardinalityQualified(x, Integer.parseInt( n.image ), y);}
    throw new Error("Missing return statement in function");
  }

/* 8.3.3 Exact Cardinality */
  final public ElkObjectExactCardinality objectExactCardinality() throws ParseException {
        Token n;
        ElkObjectPropertyExpression x;
        ElkClassExpression y = null;
    jj_consume_token(OBJECT_EXACT_CARDINALITY);
    jj_consume_token(OPEN_BRACKET);
    n = jj_consume_token(NON_NEGATIVE_INTEGER);
    x = objectPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OBJECT_INTERSECTION_OF:
    case OBJECT_UNION_OF:
    case OBJECT_COMPLEMENT_OF:
    case OBJECT_ONE_OF:
    case OBJECT_SOME_VALUES_FROM:
    case OBJECT_ALL_VALUES_FROM:
    case OBJECT_HAS_VALUE:
    case OBJECT_HAS_SELF:
    case OBJECT_MIN_CARDINALITY:
    case OBJECT_MAX_CARDINALITY:
    case OBJECT_EXACT_CARDINALITY:
    case DATA_SOME_VALUES_FROM:
    case DATA_ALL_VALUES_FROM:
    case DATA_HAS_VALUE:
    case DATA_MIN_CARDINALITY:
    case DATA_MAX_CARDINALITY:
    case DATA_EXACT_CARDINALITY:
    case PNAME_NS:
    case FULL_IRI:
      y = classExpression();
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
                if (y == null)
                        {if (true) return getElkObjectFactory().getObjectExactCardinality(x, Integer.parseInt( n.image ));}
                else
                        {if (true) return getElkObjectFactory().getObjectExactCardinalityQualified(x, Integer.parseInt( n.image ), y);}
    throw new Error("Missing return statement in function");
  }

/* 8.4 Data Property Restrictions */

/* 8.4.1 Existential Quantification */
  final public ElkDataSomeValuesFrom dataSomeValuesFrom() throws ParseException {
        Vector<ElkDataPropertyExpression> dpList = new Vector<ElkDataPropertyExpression>();
        ElkDataRange dr;
        ElkDataSomeValuesFrom result = null;
    jj_consume_token(DATA_SOME_VALUES_FROM);
    jj_consume_token(OPEN_BRACKET);
    addDataPropertyExpression(dpList);
    result = dataSomeValuesFromSuffix(dpList);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public ElkDataSomeValuesFrom dataSomeValuesFromSuffix(Vector<ElkDataPropertyExpression> dpList) throws ParseException {
        ElkDataRange dr = null;
        ElkDataSomeValuesFrom result = null;
    if (jj_2_1(3)) {
      dr = dataRange();
      jj_consume_token(CLOSE_BRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PNAME_NS:
      case FULL_IRI:
        addDataPropertyExpression(dpList);
        result = dataSomeValuesFromSuffix(dpList);
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return getElkObjectFactory().getDataSomeValuesFrom(dr, dpList);}
    throw new Error("Missing return statement in function");
  }

/* 8.4.2 Universal Quantification */
  final public ElkDataAllValuesFrom dataAllValuesFrom() throws ParseException {
        Vector<ElkDataPropertyExpression> dpList = new Vector<ElkDataPropertyExpression>();
        ElkDataRange dr;
        ElkDataAllValuesFrom result = null;
    jj_consume_token(DATA_ALL_VALUES_FROM);
    jj_consume_token(OPEN_BRACKET);
    addDataPropertyExpression(dpList);
    result = dataAllValuesFromSuffix(dpList);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public ElkDataAllValuesFrom dataAllValuesFromSuffix(Vector<ElkDataPropertyExpression> dpList) throws ParseException {
        ElkDataRange dr = null;
        ElkDataAllValuesFrom result = null;
    if (jj_2_2(3)) {
      dr = dataRange();
      jj_consume_token(CLOSE_BRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PNAME_NS:
      case FULL_IRI:
        addDataPropertyExpression(dpList);
        result = dataAllValuesFromSuffix(dpList);
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return getElkObjectFactory().getDataAllValuesFrom(dr, dpList);}
    throw new Error("Missing return statement in function");
  }

/* 8.4.3 Literal Value Restriction */
  final public ElkDataHasValue dataHasValue() throws ParseException {
        ElkDataPropertyExpression x;
        ElkLiteral y;
    jj_consume_token(DATA_HAS_VALUE);
    jj_consume_token(OPEN_BRACKET);
    x = dataPropertyExpression();
    y = literal();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDataHasValue(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 8.5 Data Property Cardinality Restrictions */

/* 8.5.1 Minimum Cardinality */
  final public ElkDataMinCardinality dataMinCardinality() throws ParseException {
        Token n;
        ElkDataPropertyExpression x;
        ElkDataRange y = null;
    jj_consume_token(DATA_MIN_CARDINALITY);
    jj_consume_token(OPEN_BRACKET);
    n = jj_consume_token(NON_NEGATIVE_INTEGER);
    x = dataPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATATYPE_RESTRICTION:
    case DATA_INTERSECTION_OF:
    case DATA_UNION_OF:
    case DATA_COMPLEMENT_OF:
    case DATA_ONE_OF:
    case PNAME_NS:
    case FULL_IRI:
      y = dataRange();
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
                if (y == null)
                        {if (true) return getElkObjectFactory().getDataMinCardinality(x, Integer.parseInt( n.image ));}
                else
                        {if (true) return getElkObjectFactory().getDataMinCardinalityQualified(x, Integer.parseInt( n.image ), y);}
    throw new Error("Missing return statement in function");
  }

/* 8.5.2 Maximum Cardinality */
  final public ElkDataMaxCardinality dataMaxCardinality() throws ParseException {
        Token n;
        ElkDataPropertyExpression x;
        ElkDataRange y = null;
    jj_consume_token(DATA_MAX_CARDINALITY);
    jj_consume_token(OPEN_BRACKET);
    n = jj_consume_token(NON_NEGATIVE_INTEGER);
    x = dataPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATATYPE_RESTRICTION:
    case DATA_INTERSECTION_OF:
    case DATA_UNION_OF:
    case DATA_COMPLEMENT_OF:
    case DATA_ONE_OF:
    case PNAME_NS:
    case FULL_IRI:
      y = dataRange();
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
                if (y == null)
                        {if (true) return getElkObjectFactory().getDataMaxCardinality(x, Integer.parseInt( n.image ));}
                else
                        {if (true) return getElkObjectFactory().getDataMaxCardinalityQualified(x, Integer.parseInt( n.image ), y);}
    throw new Error("Missing return statement in function");
  }

/* 8.5.3 Exact Cardinality */
  final public ElkDataExactCardinality dataExactCardinality() throws ParseException {
        Token n;
        ElkDataPropertyExpression x;
        ElkDataRange y = null;
    jj_consume_token(DATA_EXACT_CARDINALITY);
    jj_consume_token(OPEN_BRACKET);
    n = jj_consume_token(NON_NEGATIVE_INTEGER);
    x = dataPropertyExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATATYPE_RESTRICTION:
    case DATA_INTERSECTION_OF:
    case DATA_UNION_OF:
    case DATA_COMPLEMENT_OF:
    case DATA_ONE_OF:
    case PNAME_NS:
    case FULL_IRI:
      y = dataRange();
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
                if (y == null)
                        {if (true) return getElkObjectFactory().getDataExactCardinality(x, Integer.parseInt( n.image ));}
                else
                        {if (true) return getElkObjectFactory().getDataExactCardinalityQualified(x, Integer.parseInt( n.image ), y);}
    throw new Error("Missing return statement in function");
  }

/* 9 Axioms */
  final public ElkAxiom axiom() throws ParseException {
        ElkAxiom x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECLARATION:
      x = declaration();
      break;
    case SUB_CLASS_OF:
    case EQUIVALENT_CLASSES:
    case DISJOINT_CLASSES:
    case DISJOINT_UNION:
      x = classAxiom();
      break;
    case SUB_OBJECT_PROPERTY_OF:
    case EQUIVALENT_OBJECT_PROPERTIES:
    case DISJOINT_OBJECT_PROPERTIES:
    case OBJECT_PROPERTY_DOMAIN:
    case OBJECT_PROPERTY_RANGE:
    case INVERSE_OBJECT_PROPERTIES:
    case FUNCTIONAL_OBJECT_PROPERTY:
    case INVERSE_FUNCTIONAL_OBJECT_PROPERTY:
    case REFLEXIVE_OBJECT_PROPERTY:
    case IRREFLEXIVE_OBJECT_PROPERTY:
    case SYMMETRIC_OBJECT_PROPERTY:
    case ASYMMETRIC_OBJECT_PROPERTY:
    case TRANSITIVE_OBJECT_PROPERTY:
      x = objectPropertyAxiom();
      break;
    case SUB_DATA_PROPERTY_OF:
    case EQUIVALENT_DATA_PROPERTIES:
    case DISJOINT_DATA_PROPERTIES:
    case DATA_PROPERTY_DOMAIN:
    case DATA_PROPERTY_RANGE:
    case FUNCTIONAL_DATA_PROPERTY:
      x = dataPropertyAxiom();
      break;
    case DATATYPE_DEFINITION:
      x = datatypeDefinition();
      break;
    case HAS_KEY:
      x = hasKey();
      break;
    case SAME_INDIVIDUAL:
    case DIFFERENT_INDIVIDUALS:
    case CLASS_ASSERTION:
    case OBJECT_PROPERTY_ASSERTION:
    case NEGATIVE_OBJECT_PROPERTY_ASSERTION:
    case DATA_PROPERTY_ASSERTION:
    case NEGATIVE_DATA_PROPERTY_ASSERTION:
      x = assertion();
      break;
    case ANNOTATION_ASSERTION:
    case SUB_ANNOTATION_PROPERTY_OF:
    case ANNOTATION_PROPERTY_DOMAIN:
    case ANNOTATION_PROPERTY_RANGE:
      x = annotationAxiom();
      break;
    case SWRL_RULE:
      x = dlSafeRule();
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public void axiomAnnotations() throws ParseException {
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANNOTATION:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_9;
      }
      annotation();
    }
  }

/* 9.1 Class Expression Axioms */
  final public ElkClassAxiom classAxiom() throws ParseException {
        ElkClassAxiom x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUB_CLASS_OF:
      x = subClassOf();
      break;
    case EQUIVALENT_CLASSES:
      x = equivalentClasses();
      break;
    case DISJOINT_CLASSES:
      x = disjointClasses();
      break;
    case DISJOINT_UNION:
      x = disjointUnion();
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
       {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/* 9.1.1 Subclass Axioms */
  final public ElkSubClassOfAxiom subClassOf() throws ParseException {
        ElkClassExpression x, y;
    jj_consume_token(SUB_CLASS_OF);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = classExpression();
    y = classExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getSubClassOfAxiom(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 9.1.2 Equivalent Classes */
  final public ElkEquivalentClassesAxiom equivalentClasses() throws ParseException {
        Vector<ElkClassExpression> v;
    jj_consume_token(EQUIVALENT_CLASSES);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    v = classExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getEquivalentClassesAxiom(v);}
    throw new Error("Missing return statement in function");
  }

/* 9.1.3 Disjoint Classes */
  final public ElkDisjointClassesAxiom disjointClasses() throws ParseException {
        Vector<ElkClassExpression> v;
    jj_consume_token(DISJOINT_CLASSES);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    v = classExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDisjointClassesAxiom(v);}
    throw new Error("Missing return statement in function");
  }

/* 9.1.4 Disjoint Union of Class Expressions */
  final public ElkDisjointUnionAxiom disjointUnion() throws ParseException {
        ElkClass x;
        Vector<ElkClassExpression> v;
    jj_consume_token(DISJOINT_UNION);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = clazz();
    v = classExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDisjointUnionAxiom(x, v);}
    throw new Error("Missing return statement in function");
  }

  final public Vector<ElkClassExpression> classExpressionList() throws ParseException {
        ElkClassExpression x;
        Vector<ElkClassExpression> v =
                new Vector<ElkClassExpression> ();
    x = classExpression();
                                v.add(x);
    label_10:
    while (true) {
      x = classExpression();
                                  v.add(x);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OBJECT_INTERSECTION_OF:
      case OBJECT_UNION_OF:
      case OBJECT_COMPLEMENT_OF:
      case OBJECT_ONE_OF:
      case OBJECT_SOME_VALUES_FROM:
      case OBJECT_ALL_VALUES_FROM:
      case OBJECT_HAS_VALUE:
      case OBJECT_HAS_SELF:
      case OBJECT_MIN_CARDINALITY:
      case OBJECT_MAX_CARDINALITY:
      case OBJECT_EXACT_CARDINALITY:
      case DATA_SOME_VALUES_FROM:
      case DATA_ALL_VALUES_FROM:
      case DATA_HAS_VALUE:
      case DATA_MIN_CARDINALITY:
      case DATA_MAX_CARDINALITY:
      case DATA_EXACT_CARDINALITY:
      case PNAME_NS:
      case FULL_IRI:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_10;
      }
    }
          {if (true) return v;}
    throw new Error("Missing return statement in function");
  }

/* 9.2 Object Property Axioms */
  final public ElkObjectPropertyAxiom objectPropertyAxiom() throws ParseException {
        ElkObjectPropertyAxiom x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUB_OBJECT_PROPERTY_OF:
      x = subObjectPropertyOf();
      break;
    case EQUIVALENT_OBJECT_PROPERTIES:
      x = equivalentObjectProperties();
      break;
    case DISJOINT_OBJECT_PROPERTIES:
      x = disjointObjectProperties();
      break;
    case INVERSE_OBJECT_PROPERTIES:
      x = inverseObjectProperties();
      break;
    case OBJECT_PROPERTY_DOMAIN:
      x = objectPropertyDomain();
      break;
    case OBJECT_PROPERTY_RANGE:
      x = objectPropertyRange();
      break;
    case FUNCTIONAL_OBJECT_PROPERTY:
      x = functionalObjectProperty();
      break;
    case INVERSE_FUNCTIONAL_OBJECT_PROPERTY:
      x = inverseFunctionalObjectProperty();
      break;
    case REFLEXIVE_OBJECT_PROPERTY:
      x = reflexiveObjectProperty();
      break;
    case IRREFLEXIVE_OBJECT_PROPERTY:
      x = irreflexiveObjectProperty();
      break;
    case SYMMETRIC_OBJECT_PROPERTY:
      x = symmetricObjectProperty();
      break;
    case ASYMMETRIC_OBJECT_PROPERTY:
      x = asymmetricObjectProperty();
      break;
    case TRANSITIVE_OBJECT_PROPERTY:
      x = transitiveObjectProperty();
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/* 9.2.1 Object Subproperties */
  final public ElkSubObjectPropertyOfAxiom subObjectPropertyOf() throws ParseException {
        ElkSubObjectPropertyExpression x = null;
        ElkObjectPropertyExpression z;
    jj_consume_token(SUB_OBJECT_PROPERTY_OF);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OBJECT_INVERSE_OF:
    case PNAME_NS:
    case FULL_IRI:
      x = objectPropertyExpression();
      break;
    case OBJECT_PROPERTY_CHAIN:
      x = propertyExpressionChain();
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    z = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getSubObjectPropertyOfAxiom(x, z);}
    throw new Error("Missing return statement in function");
  }

  final public ElkObjectPropertyChain propertyExpressionChain() throws ParseException {
        Vector<ElkObjectPropertyExpression> v;
    jj_consume_token(OBJECT_PROPERTY_CHAIN);
    jj_consume_token(OPEN_BRACKET);
    v = objectPropertyExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectPropertyChain(v);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.2 Equivalent Object Properties */
  final public ElkEquivalentObjectPropertiesAxiom equivalentObjectProperties() throws ParseException {
        Vector<ElkObjectPropertyExpression> v;
    jj_consume_token(EQUIVALENT_OBJECT_PROPERTIES);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    v = objectPropertyExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getEquivalentObjectPropertiesAxiom(v);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.3 Disjoint Object Properties */
  final public ElkDisjointObjectPropertiesAxiom disjointObjectProperties() throws ParseException {
        Vector<ElkObjectPropertyExpression> v;
    jj_consume_token(DISJOINT_OBJECT_PROPERTIES);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    v = objectPropertyExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDisjointObjectPropertiesAxiom(v);}
    throw new Error("Missing return statement in function");
  }

  final public Vector<ElkObjectPropertyExpression> objectPropertyExpressionList() throws ParseException {
        ElkObjectPropertyExpression x;
        Vector<ElkObjectPropertyExpression> v =
                new Vector<ElkObjectPropertyExpression> ();
    x = objectPropertyExpression();
                                         v.add(x);
    label_11:
    while (true) {
      x = objectPropertyExpression();
                                           v.add(x);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OBJECT_INVERSE_OF:
      case PNAME_NS:
      case FULL_IRI:
        ;
        break;
      default:
        jj_la1[32] = jj_gen;
        break label_11;
      }
    }
          {if (true) return v;}
    throw new Error("Missing return statement in function");
  }

/* 9.2.4 Inverse Object Properties */
  final public ElkInverseObjectPropertiesAxiom inverseObjectProperties() throws ParseException {
        ElkObjectPropertyExpression x, y;
    jj_consume_token(INVERSE_OBJECT_PROPERTIES);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    y = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getInverseObjectPropertiesAxiom(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.5 Object Property Domain */
  final public ElkObjectPropertyDomainAxiom objectPropertyDomain() throws ParseException {
        ElkObjectPropertyExpression x;
        ElkClassExpression y;
    jj_consume_token(OBJECT_PROPERTY_DOMAIN);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    y = classExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectPropertyDomainAxiom(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.6 Object Property Range */
  final public ElkObjectPropertyRangeAxiom objectPropertyRange() throws ParseException {
        ElkObjectPropertyExpression x;
        ElkClassExpression y;
    jj_consume_token(OBJECT_PROPERTY_RANGE);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    y = classExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectPropertyRangeAxiom(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.7 Functional Object Properties */
  final public ElkFunctionalObjectPropertyAxiom functionalObjectProperty() throws ParseException {
        ElkObjectPropertyExpression x;
    jj_consume_token(FUNCTIONAL_OBJECT_PROPERTY);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getFunctionalObjectPropertyAxiom(x);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.8 Inverse-Functional Object Properties */
  final public ElkInverseFunctionalObjectPropertyAxiom inverseFunctionalObjectProperty() throws ParseException {
        ElkObjectPropertyExpression x;
    jj_consume_token(INVERSE_FUNCTIONAL_OBJECT_PROPERTY);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getInverseFunctionalObjectPropertyAxiom(x);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.9 Reflexive Object Properties */
  final public ElkReflexiveObjectPropertyAxiom reflexiveObjectProperty() throws ParseException {
        ElkObjectPropertyExpression x;
    jj_consume_token(REFLEXIVE_OBJECT_PROPERTY);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getReflexiveObjectPropertyAxiom(x);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.10 Irreflexive Object Properties */
  final public ElkIrreflexiveObjectPropertyAxiom irreflexiveObjectProperty() throws ParseException {
        ElkObjectPropertyExpression x;
    jj_consume_token(IRREFLEXIVE_OBJECT_PROPERTY);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getIrreflexiveObjectPropertyAxiom(x);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.11 Symmetric Object Properties */
  final public ElkSymmetricObjectPropertyAxiom symmetricObjectProperty() throws ParseException {
        ElkObjectPropertyExpression x;
    jj_consume_token(SYMMETRIC_OBJECT_PROPERTY);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getSymmetricObjectPropertyAxiom(x);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.12 Asymmetric Object Properties */
  final public ElkAsymmetricObjectPropertyAxiom asymmetricObjectProperty() throws ParseException {
        ElkObjectPropertyExpression x;
    jj_consume_token(ASYMMETRIC_OBJECT_PROPERTY);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getAsymmetricObjectPropertyAxiom(x);}
    throw new Error("Missing return statement in function");
  }

/* 9.2.13 Transitive Object Properties */
  final public ElkTransitiveObjectPropertyAxiom transitiveObjectProperty() throws ParseException {
        ElkObjectPropertyExpression x;
    jj_consume_token(TRANSITIVE_OBJECT_PROPERTY);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getTransitiveObjectPropertyAxiom(x);}
    throw new Error("Missing return statement in function");
  }

/* 9.3 Data Property Axioms */
  final public ElkDataPropertyAxiom dataPropertyAxiom() throws ParseException {
        ElkDataPropertyAxiom x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUB_DATA_PROPERTY_OF:
      x = subDataPropertyOf();
      break;
    case EQUIVALENT_DATA_PROPERTIES:
      x = equivalentDataProperties();
      break;
    case DISJOINT_DATA_PROPERTIES:
      x = disjointDataProperties();
      break;
    case DATA_PROPERTY_DOMAIN:
      x = dataPropertyDomain();
      break;
    case DATA_PROPERTY_RANGE:
      x = dataPropertyRange();
      break;
    case FUNCTIONAL_DATA_PROPERTY:
      x = functionalDataProperty();
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/* 9.3.1 Data Subproperties */
  final public ElkSubDataPropertyOfAxiom subDataPropertyOf() throws ParseException {
        ElkDataPropertyExpression sub,sup;
    jj_consume_token(SUB_DATA_PROPERTY_OF);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    sub = dataPropertyExpression();
    sup = dataPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getSubDataPropertyOfAxiom(sub, sup);}
    throw new Error("Missing return statement in function");
  }

/* 9.3.2 Equivalent Data Properties */
  final public ElkEquivalentDataPropertiesAxiom equivalentDataProperties() throws ParseException {
        Vector<ElkDataPropertyExpression> v;
    jj_consume_token(EQUIVALENT_DATA_PROPERTIES);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    v = dataPropertyExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getEquivalentDataPropertiesAxiom(v);}
    throw new Error("Missing return statement in function");
  }

/* 9.3.3 Disjoint Data Properties */
  final public ElkDisjointDataPropertiesAxiom disjointDataProperties() throws ParseException {
        Vector<ElkDataPropertyExpression> v;
    jj_consume_token(DISJOINT_DATA_PROPERTIES);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    v = dataPropertyExpressionList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDisjointDataPropertiesAxiom(v);}
    throw new Error("Missing return statement in function");
  }

  final public Vector<ElkDataPropertyExpression> dataPropertyExpressionList() throws ParseException {
        ElkDataPropertyExpression x;
        Vector<ElkDataPropertyExpression> v =
                new Vector<ElkDataPropertyExpression> ();
    x = dataPropertyExpression();
                                       v.add(x);
    label_12:
    while (true) {
      x = dataPropertyExpression();
                                         v.add(x);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PNAME_NS:
      case FULL_IRI:
        ;
        break;
      default:
        jj_la1[34] = jj_gen;
        break label_12;
      }
    }
          {if (true) return v;}
    throw new Error("Missing return statement in function");
  }

/* 9.3.4 Data Property Domain */
  final public ElkDataPropertyDomainAxiom dataPropertyDomain() throws ParseException {
        ElkDataPropertyExpression x;
        ElkClassExpression y;
    jj_consume_token(DATA_PROPERTY_DOMAIN);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = dataPropertyExpression();
    y = classExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDataPropertyDomainAxiom(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 9.3.5 Data Property Range */
  final public ElkDataPropertyRangeAxiom dataPropertyRange() throws ParseException {
        ElkDataPropertyExpression x;
        ElkDataRange y;
    jj_consume_token(DATA_PROPERTY_RANGE);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = dataPropertyExpression();
    y = dataRange();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDataPropertyRangeAxiom(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 9.3.6 Functional Data Properties */
  final public ElkFunctionalDataPropertyAxiom functionalDataProperty() throws ParseException {
        ElkDataPropertyExpression x;
    jj_consume_token(FUNCTIONAL_DATA_PROPERTY);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = dataPropertyExpression();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getFunctionalDataPropertyAxiom(x);}
    throw new Error("Missing return statement in function");
  }

/* 9.4 Datatype Definitions */
  final public ElkDatatypeDefinitionAxiom datatypeDefinition() throws ParseException {
        ElkDatatype dt = null;
        ElkDataRange dr = null;
    jj_consume_token(DATATYPE_DEFINITION);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    dt = datatype();
    dr = dataRange();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDatatypeDefinitionAxiom(dt, dr);}
    throw new Error("Missing return statement in function");
  }

/* 9.5 Keys */
  final public ElkHasKeyAxiom hasKey() throws ParseException {
        ElkClassExpression ce = null;
        Set<ElkObjectPropertyExpression> opexprs = new HashSet<ElkObjectPropertyExpression>();
        Set<ElkDataPropertyExpression> dpexprs = new HashSet<ElkDataPropertyExpression>();
    jj_consume_token(HAS_KEY);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    ce = classExpression();
    jj_consume_token(OPEN_BRACKET);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OBJECT_INVERSE_OF:
      case PNAME_NS:
      case FULL_IRI:
        ;
        break;
      default:
        jj_la1[35] = jj_gen;
        break label_13;
      }
      addObjectPropertyExpression(opexprs);
    }
    jj_consume_token(CLOSE_BRACKET);
    jj_consume_token(OPEN_BRACKET);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PNAME_NS:
      case FULL_IRI:
        ;
        break;
      default:
        jj_la1[36] = jj_gen;
        break label_14;
      }
      addDataPropertyExpression(dpexprs);
    }
    jj_consume_token(CLOSE_BRACKET);
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getHasKeyAxiom(ce, opexprs, dpexprs);}
    throw new Error("Missing return statement in function");
  }

/* SWRL Rules, we don't parse them, just skip through */
  final public ElkSWRLRule dlSafeRule() throws ParseException {
    jj_consume_token(SWRL_RULE);
    jj_consume_token(OPEN_BRACKET);
    skipToMatchingBrace();
         {if (true) return getElkObjectFactory().getSWRLRule();}
    throw new Error("Missing return statement in function");
  }

  void skipToMatchingBrace() throws ParseException {
      Token tok;
      int nesting = 1;
      while (true) {
        tok = getNextToken();

        if (tok.kind == OPEN_BRACKET) nesting++;
        if (tok.kind == CLOSE_BRACKET) {
          nesting--;
          if (nesting == 0) break;
        }
      }
  }

/* 9.6 Assertions */
  final public ElkAssertionAxiom assertion() throws ParseException {
        ElkAssertionAxiom x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SAME_INDIVIDUAL:
      x = sameIndividual();
      break;
    case DIFFERENT_INDIVIDUALS:
      x = differentIndividuals();
      break;
    case CLASS_ASSERTION:
      x = classAssertion();
      break;
    case OBJECT_PROPERTY_ASSERTION:
      x = objectPropertyAssertion();
      break;
    case NEGATIVE_OBJECT_PROPERTY_ASSERTION:
      x = negativeObjectPropertyAssertion();
      break;
    case DATA_PROPERTY_ASSERTION:
      x = dataPropertyAssertion();
      break;
    case NEGATIVE_DATA_PROPERTY_ASSERTION:
      x = negativeDataPropertyAssertion();
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/* 9.6.1 Individual Equality */
  final public ElkSameIndividualAxiom sameIndividual() throws ParseException {
        Vector<ElkIndividual> v;
    jj_consume_token(SAME_INDIVIDUAL);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    v = individualList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getSameIndividualAxiom(v);}
    throw new Error("Missing return statement in function");
  }

/* 9.6.2 Individual Inequality */
  final public ElkDifferentIndividualsAxiom differentIndividuals() throws ParseException {
        Vector<ElkIndividual> v;
    jj_consume_token(DIFFERENT_INDIVIDUALS);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    v = individualList();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDifferentIndividualsAxiom(v);}
    throw new Error("Missing return statement in function");
  }

  final public Vector<ElkIndividual> individualList() throws ParseException {
        ElkIndividual x;
        Vector<ElkIndividual> v =
                new Vector<ElkIndividual> ();
    x = individual();
                           v.add(x);
    label_15:
    while (true) {
      x = individual();
                             v.add(x);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PNAME_NS:
      case BLANK_NODE_PREFIX:
      case FULL_IRI:
        ;
        break;
      default:
        jj_la1[38] = jj_gen;
        break label_15;
      }
    }
          {if (true) return v;}
    throw new Error("Missing return statement in function");
  }

/* 9.6.3 Class Assertions */
  final public ElkClassAssertionAxiom classAssertion() throws ParseException {
        ElkClassExpression x;
        ElkIndividual y;
    jj_consume_token(CLASS_ASSERTION);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = classExpression();
    y = individual();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getClassAssertionAxiom(x, y);}
    throw new Error("Missing return statement in function");
  }

/* 9.6.4 Positive Object Property Assertions */
  final public ElkObjectPropertyAssertionAxiom objectPropertyAssertion() throws ParseException {
        ElkObjectPropertyExpression x;
        ElkIndividual sourceIndividual, targetIndividual;
    jj_consume_token(OBJECT_PROPERTY_ASSERTION);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    sourceIndividual = individual();
    targetIndividual = individual();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getObjectPropertyAssertionAxiom(x, sourceIndividual, targetIndividual);}
    throw new Error("Missing return statement in function");
  }

/* 9.6.5 Negative Object Property Assertions */
  final public ElkNegativeObjectPropertyAssertionAxiom negativeObjectPropertyAssertion() throws ParseException {
        ElkObjectPropertyExpression x;
        ElkIndividual sourceIndividual, targetIndividual;
    jj_consume_token(NEGATIVE_OBJECT_PROPERTY_ASSERTION);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = objectPropertyExpression();
    sourceIndividual = individual();
    targetIndividual = individual();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getNegativeObjectPropertyAssertionAxiom(x, sourceIndividual, targetIndividual);}
    throw new Error("Missing return statement in function");
  }

/* 9.6.6 Positive Data Property Assertions */
  final public ElkDataPropertyAssertionAxiom dataPropertyAssertion() throws ParseException {
        ElkDataPropertyExpression x;
        ElkIndividual sourceIndividual;
        ElkLiteral targetLiteral;
    jj_consume_token(DATA_PROPERTY_ASSERTION);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = dataPropertyExpression();
    sourceIndividual = individual();
    targetLiteral = literal();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getDataPropertyAssertionAxiom(x, sourceIndividual, targetLiteral);}
    throw new Error("Missing return statement in function");
  }

/* 9.6.7 Negative Data Property Assertions */
  final public ElkNegativeDataPropertyAssertionAxiom negativeDataPropertyAssertion() throws ParseException {
        ElkDataPropertyExpression x;
        ElkIndividual sourceIndividual;
        ElkLiteral targetLiteral;
    jj_consume_token(NEGATIVE_DATA_PROPERTY_ASSERTION);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    x = dataPropertyExpression();
    sourceIndividual = individual();
    targetLiteral = literal();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getNegativeDataPropertyAssertionAxiom(x, sourceIndividual, targetLiteral);}
    throw new Error("Missing return statement in function");
  }

/* 10 Annotations */

/* 10.1 Annotations of Ontologies, Axioms, and other Annotations */
//TODO annotations are not part of the ELK model, the returned value is ignored 
  final public ElkAnnotation annotation() throws ParseException {
        ElkAnnotationProperty property;
        ElkAnnotationValue value;
    jj_consume_token(ANNOTATION);
    jj_consume_token(OPEN_BRACKET);
    annotationAnnotations();
    property = annotationProperty();
    value = annotationValue();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getAnnotation(property, value);}
    throw new Error("Missing return statement in function");
  }

  final public void annotationAnnotations() throws ParseException {
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANNOTATION:
        ;
        break;
      default:
        jj_la1[39] = jj_gen;
        break label_16;
      }
      annotation();
    }
  }

  final public ElkAnnotationValue annotationValue() throws ParseException {
        ElkAnnotationValue value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLANK_NODE_PREFIX:
      value = anonymousIndividual();
      break;
    case PNAME_NS:
    case FULL_IRI:
      value = iri();
      break;
    case QUOTED_STRING:
      value = literal();
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/* 10.2 Annotation Axioms */
  final public ElkAnnotationAxiom annotationAxiom() throws ParseException {
        ElkAnnotationAxiom annAxiom = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANNOTATION_ASSERTION:
      annAxiom = annotationAssertion();
      break;
    case SUB_ANNOTATION_PROPERTY_OF:
      annAxiom = subAnnotationPropertyOf();
      break;
    case ANNOTATION_PROPERTY_DOMAIN:
      annAxiom = annotationPropertyDomain();
      break;
    case ANNOTATION_PROPERTY_RANGE:
      annAxiom = annotationPropertyRange();
      break;
    default:
      jj_la1[41] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return annAxiom;}
    throw new Error("Missing return statement in function");
  }

/* 10.2.1 Annotation Assertion */
  final public ElkAnnotationAssertionAxiom annotationAssertion() throws ParseException {
        ElkAnnotationProperty property = null;
        ElkAnnotationSubject subject = null;
        ElkAnnotationValue value = null;
    jj_consume_token(ANNOTATION_ASSERTION);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    property = annotationProperty();
    subject = annotationSubject();
    value = annotationValue();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getAnnotationAssertionAxiom(property, subject, value);}
    throw new Error("Missing return statement in function");
  }

  final public ElkAnnotationSubject annotationSubject() throws ParseException {
        ElkAnnotationSubject subject = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PNAME_NS:
    case FULL_IRI:
      subject = iri();
      break;
    case BLANK_NODE_PREFIX:
      subject = anonymousIndividual();
      break;
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return subject;}
    throw new Error("Missing return statement in function");
  }

/* 10.2.2 Annotation Subproperties */
  final public ElkSubAnnotationPropertyOfAxiom subAnnotationPropertyOf() throws ParseException {
        ElkAnnotationProperty subProperty = null;
        ElkAnnotationProperty superProperty = null;
    jj_consume_token(SUB_ANNOTATION_PROPERTY_OF);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    subProperty = annotationProperty();
    superProperty = annotationProperty();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getSubAnnotationPropertyOfAxiom(subProperty, superProperty);}
    throw new Error("Missing return statement in function");
  }

/* 10.2.3 Annotation Property Domain */
  final public ElkAnnotationPropertyDomainAxiom annotationPropertyDomain() throws ParseException {
        ElkAnnotationProperty property = null;
        ElkIri domain = null;
    jj_consume_token(ANNOTATION_PROPERTY_DOMAIN);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    property = annotationProperty();
    domain = iri();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getAnnotationPropertyDomainAxiom(property, domain);}
    throw new Error("Missing return statement in function");
  }

/* 10.2.4 Annotation Property Range */
  final public ElkAnnotationPropertyRangeAxiom annotationPropertyRange() throws ParseException {
        ElkAnnotationProperty property = null;
        ElkIri range = null;
    jj_consume_token(ANNOTATION_PROPERTY_RANGE);
    jj_consume_token(OPEN_BRACKET);
    axiomAnnotations();
    property = annotationProperty();
    range = iri();
    jj_consume_token(CLOSE_BRACKET);
                {if (true) return getElkObjectFactory().getAnnotationPropertyRangeAxiom(property, range);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_3R_29() {
    if (jj_scan_token(DATATYPE_RESTRICTION)) return true;
    if (jj_scan_token(OPEN_BRACKET)) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_17()) return true;
    if (jj_scan_token(CLOSE_BRACKET)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(DATA_INTERSECTION_OF)) return true;
    if (jj_scan_token(OPEN_BRACKET)) return true;
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_scan_token(FULL_IRI)) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_scan_token(PNAME_NS)) return true;
    return false;
  }

  private boolean jj_3R_28() {
    if (jj_scan_token(DATA_ONE_OF)) return true;
    if (jj_scan_token(OPEN_BRACKET)) return true;
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_3R_38()) return true;
    if (jj_scan_token(PN_LOCAL)) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(DATA_COMPLEMENT_OF)) return true;
    if (jj_scan_token(OPEN_BRACKET)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_17()) return true;
    if (jj_scan_token(CLOSE_BRACKET)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(DATA_UNION_OF)) return true;
    if (jj_scan_token(OPEN_BRACKET)) return true;
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    return false;
  }

  /** Generated Token Manager. */
  public AbstractOwl2FunctionalStyleParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[43];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x200,0x0,0x0,0x800,0x40000,0x0,0x0,0x100,0x3f000,0x80000,0x800000,0x800000,0x0,0x0,0xff000000,0x0,0xff000000,0xff000000,0xff000000,0x0,0x0,0x800000,0x800000,0x800000,0x40000,0x0,0x0,0xff000000,0x0,0x180000,0x80000,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0xffffe000,0x0,0x0,0x0,0x0,0x0,0x78,0x78,0x0,0x0,0x1f87,0x0,0x1f87,0x1f87,0x1f87,0x0,0x0,0x78,0x78,0x78,0xffffe000,0x0,0x1e000,0x1f87,0x3ffe0000,0x0,0x0,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x80000000,0x1000000,0x0,0x80000000,0x80000000,0x0,0x1efe007f,0x80000000,0x40000000,0x0,0x0,0x80000000,0x80000000,0x80000000,0x0,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x1efe007f,0x1000000,0x0,0x80000000,0x0,0x80000000,0x80000000,0xf,0x80000000,0x80000000,0x80000000,0xfe0000,0x80000000,0x1000000,0x80000000,0x1e000000,0x80000000,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x200,0x0,0x0,0x200,0x200,0x0,0x0,0x202,0x0,0x0,0x0,0x200,0x200,0x200,0x2000,0x200,0x200,0x202,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x0,0x0,0x0,0x200,0x0,0x200,0x200,0x0,0x200,0x200,0x200,0x0,0x202,0x0,0x2202,0x0,0x202,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public AbstractOwl2FunctionalStyleParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public AbstractOwl2FunctionalStyleParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new AbstractOwl2FunctionalStyleParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 43; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 43; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public AbstractOwl2FunctionalStyleParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new AbstractOwl2FunctionalStyleParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 43; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 43; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public AbstractOwl2FunctionalStyleParser(AbstractOwl2FunctionalStyleParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 43; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(AbstractOwl2FunctionalStyleParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 43; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[114];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 43; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 114; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
