/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.printers;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.parsing.ElkTestAxiomProcessor;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;
import org.semanticweb.elk.owl.printers.ModelOwl2FunctionalSyntaxPrinterTest;

public abstract class AbstractImplOwl2FunctionalSyntaxPrinterTest
extends ModelOwl2FunctionalSyntaxPrinterTest {
    protected Set<? extends ElkObject> getOriginalElkObjects(List<ElkPrefix> prefixes) {
        InputStream input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("owl2primer.owl");
        Assert.assertNotNull((Object)input);
        return this.parseAxioms(new InputStreamReader(input), prefixes, false);
    }

    protected Set<? extends ElkObject> loadPrintedElkObjects(String input, List<ElkPrefix> prefixes) {
        String ontology = " Ontology(<http://example.com/owl/> \n" + input + "\n)";
        return this.parseAxioms(new StringReader(ontology), prefixes, true);
    }

    protected Set<? extends ElkObject> parseAxioms(Reader reader, List<ElkPrefix> prefixes, boolean addDefaultDecl) {
        Owl2Parser parser = this.instantiateParser(reader);
        ElkTestAxiomProcessor counter = new ElkTestAxiomProcessor();
        if (addDefaultDecl) {
            for (ElkPrefix prefix : prefixes) {
                parser.declarePrefix(prefix);
            }
        }
        try {
            parser.accept((Owl2ParserAxiomProcessor)counter);
            prefixes.addAll(counter.getDeclaredPrefixes());
        }
        catch (Owl2ParseException e) {
            throw new RuntimeException("Failed to load axioms for testing", e);
        }
        return counter.getAllAxioms();
    }

    protected abstract Owl2Parser instantiateParser(Reader var1);
}

