/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.parsing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;

public class ElkTestAxiomProcessor
implements Owl2ParserAxiomProcessor {
    private Map<Class<?>, Set<ElkAxiom>> axiomMap = new HashMap();
    private List<ElkPrefix> elkPrefixes = new ArrayList<ElkPrefix>();

    public void visit(ElkAxiom elkAxiom) {
        if (elkAxiom == null) {
            return;
        }
        assert (elkAxiom != null) : "The parser failed to parse an axiom";
        Class<?> axiomType = this.getElkAxiomType(elkAxiom.getClass());
        assert (axiomType != null) : "Couldn't determine a suitable Elk OWL interface for the axiom: " + elkAxiom;
        HashSet<ElkAxiom> axioms = this.axiomMap.get(axiomType);
        axioms = axioms == null ? new HashSet<ElkAxiom>() : axioms;
        axioms.add(elkAxiom);
        this.axiomMap.put(axiomType, axioms);
    }

    private Class<?> getElkAxiomType(Class<? extends ElkAxiom> elkAxiomClass) {
        Package elkOwlPackage = ElkAxiom.class.getPackage();
        if (elkAxiomClass.isInterface() && elkAxiomClass.getPackage().equals(elkOwlPackage)) {
            return elkAxiomClass;
        }
        for (Class<?> interface_ : elkAxiomClass.getInterfaces()) {
            if (!interface_.getPackage().equals(elkOwlPackage)) continue;
            return interface_;
        }
        return null;
    }

    public int getAxiomCountForType(Class<? extends ElkAxiom> axiomClass) {
        Set<ElkAxiom> axioms = this.axiomMap.get(this.getElkAxiomType(axiomClass));
        return axioms == null ? 0 : axioms.size();
    }

    public Set<ElkAxiom> getAxiomsForType(Class<? extends ElkAxiom> axiomClass) {
        Set<ElkAxiom> axioms = this.axiomMap.get(this.getElkAxiomType(axiomClass));
        return axioms == null ? Collections.emptySet() : axioms;
    }

    public Set<Map.Entry<Class<?>, Set<ElkAxiom>>> getAxiomMapEntries() {
        return this.axiomMap.entrySet();
    }

    public Set<ElkAxiom> getAllAxioms() {
        HashSet<ElkAxiom> axioms = new HashSet<ElkAxiom>();
        for (Map.Entry<Class<?>, Set<ElkAxiom>> entry : this.getAxiomMapEntries()) {
            axioms.addAll((Collection<ElkAxiom>)entry.getValue());
        }
        return axioms;
    }

    long getTotalAxiomCount() {
        return this.getAllAxioms().size();
    }

    public List<ElkPrefix> getDeclaredPrefixes() {
        return this.elkPrefixes;
    }

    public void visit(ElkPrefix elkPrefix) throws Owl2ParseException {
        this.elkPrefixes.add(elkPrefix);
    }

    public void finish() throws Owl2ParseException {
    }
}

