/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.parsing;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.owl.implementation.ElkDataPropertyListRestrictionQualifiedImpl;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAsymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDatatypeDefinitionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDifferentIndividualsAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentDataPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalDataPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkHasKeyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkInverseObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIrreflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkNegativeDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkReflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSWRLRule;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.parsing.ElkTestAxiomProcessor;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;
import org.semanticweb.elk.owl.predefined.PredefinedElkPrefix;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;

public abstract class AbstractOwl2FunctionalSyntaxParseTest {
    protected InputStream getInputOntology(String fileName) {
        return this.getClass().getClassLoader().getResourceAsStream(fileName);
    }

    protected ElkTestAxiomProcessor parseOntology(InputStream input) throws Owl2ParseException {
        Owl2Parser parser = this.instantiateParser(input);
        ElkTestAxiomProcessor axiomCounter = new ElkTestAxiomProcessor();
        parser.accept((Owl2ParserAxiomProcessor)axiomCounter);
        return axiomCounter;
    }

    protected ElkTestAxiomProcessor parseOntology(String input) throws Owl2ParseException {
        Owl2Parser parser = this.instantiateParser(new StringReader(input));
        ElkTestAxiomProcessor axiomCounter = new ElkTestAxiomProcessor();
        parser.accept((Owl2ParserAxiomProcessor)axiomCounter);
        return axiomCounter;
    }

    protected static void setDefaultPrefixes(Owl2Parser parser) {
        for (PredefinedElkPrefix prefix : PredefinedElkPrefix.values()) {
            parser.declarePrefix(prefix.get());
        }
    }

    protected static void checkAxiomTypeCounts(ElkTestAxiomProcessor processor, Map<Class<?>, Integer> axiomTypeCounts, boolean checkAll) throws IOException {
        boolean error = false;
        for (Map.Entry<Class<?>, Set<ElkAxiom>> actualEntry : processor.getAxiomMapEntries()) {
            Integer expectedCount = AbstractOwl2FunctionalSyntaxParseTest.getExpectedCount(axiomTypeCounts, actualEntry.getKey());
            if (expectedCount == null) {
                if (checkAll) {
                    error = true;
                    AbstractOwl2FunctionalSyntaxParseTest.dumpAxioms(actualEntry.getValue());
                    System.err.println("Unexpectedly parsed axioms");
                }
            } else if (expectedCount.intValue() != actualEntry.getValue().size()) {
                error = true;
                AbstractOwl2FunctionalSyntaxParseTest.dumpAxioms(actualEntry.getValue());
                System.err.println("Wrong number of axioms parsed. Expected " + expectedCount + ", actual " + actualEntry.getValue().size());
            }
            axiomTypeCounts.remove(actualEntry.getKey());
        }
        Assert.assertFalse((String)"Parsing errors detected (see the output above)", (boolean)error);
    }

    private static int getExpectedCount(Map<Class<?>, Integer> axiomTypeCounts, Class<?> actualType) {
        int count = 0;
        for (Map.Entry<Class<?>, Integer> entry : axiomTypeCounts.entrySet()) {
            if (!entry.getKey().isAssignableFrom(actualType)) continue;
            count += entry.getValue().intValue();
        }
        return count;
    }

    private static void dumpAxioms(Set<ElkAxiom> axioms) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (ElkAxiom axiom : axioms) {
            OwlFunctionalStylePrinter.append((Appendable)builder, (ElkObject)axiom);
            builder.append("\n");
        }
        System.err.println(builder.toString());
    }

    protected abstract Owl2Parser instantiateParser(InputStream var1);

    protected abstract Owl2Parser instantiateParser(Reader var1);

    @Test
    public void testOWL2Primer() throws Exception {
        InputStream input = this.getInputOntology("owl2primer.owl");
        Assert.assertNotNull((Object)input);
        ElkTestAxiomProcessor counter = this.parseOntology(input);
        HashMap expectedCountMap = new HashMap();
        expectedCountMap.put(ElkSubClassOfAxiom.class, 8);
        expectedCountMap.put(ElkEquivalentClassesAxiom.class, 11);
        expectedCountMap.put(ElkDisjointClassesAxiom.class, 2);
        expectedCountMap.put(ElkSubObjectPropertyOfAxiom.class, 4);
        expectedCountMap.put(ElkEquivalentObjectPropertiesAxiom.class, 1);
        expectedCountMap.put(ElkEquivalentDataPropertiesAxiom.class, 1);
        expectedCountMap.put(ElkDisjointObjectPropertiesAxiom.class, 2);
        expectedCountMap.put(ElkInverseObjectPropertiesAxiom.class, 1);
        expectedCountMap.put(ElkObjectPropertyDomainAxiom.class, 1);
        expectedCountMap.put(ElkObjectPropertyRangeAxiom.class, 1);
        expectedCountMap.put(ElkDataPropertyDomainAxiom.class, 1);
        expectedCountMap.put(ElkDataPropertyRangeAxiom.class, 1);
        expectedCountMap.put(ElkAnnotationAssertionAxiom.class, 1);
        expectedCountMap.put(ElkSymmetricObjectPropertyAxiom.class, 1);
        expectedCountMap.put(ElkAsymmetricObjectPropertyAxiom.class, 1);
        expectedCountMap.put(ElkReflexiveObjectPropertyAxiom.class, 1);
        expectedCountMap.put(ElkIrreflexiveObjectPropertyAxiom.class, 1);
        expectedCountMap.put(ElkFunctionalObjectPropertyAxiom.class, 1);
        expectedCountMap.put(ElkIrreflexiveObjectPropertyAxiom.class, 1);
        expectedCountMap.put(ElkInverseFunctionalObjectPropertyAxiom.class, 1);
        expectedCountMap.put(ElkTransitiveObjectPropertyAxiom.class, 1);
        expectedCountMap.put(ElkFunctionalDataPropertyAxiom.class, 1);
        expectedCountMap.put(ElkHasKeyAxiom.class, 1);
        expectedCountMap.put(ElkDatatypeDefinitionAxiom.class, 3);
        expectedCountMap.put(ElkClassAssertionAxiom.class, 9);
        expectedCountMap.put(ElkObjectPropertyAssertionAxiom.class, 1);
        expectedCountMap.put(ElkNegativeObjectPropertyAssertionAxiom.class, 2);
        expectedCountMap.put(ElkDataPropertyAssertionAxiom.class, 1);
        expectedCountMap.put(ElkNegativeDataPropertyAssertionAxiom.class, 1);
        expectedCountMap.put(ElkSameIndividualAxiom.class, 3);
        expectedCountMap.put(ElkDifferentIndividualsAxiom.class, 1);
        expectedCountMap.put(ElkDeclarationAxiom.class, 43);
        expectedCountMap.put(ElkSWRLRule.class, 3);
        AbstractOwl2FunctionalSyntaxParseTest.checkAxiomTypeCounts(counter, expectedCountMap, false);
        Assert.assertEquals((long)111L, (long)counter.getTotalAxiomCount());
    }

    @Test
    public void testComments() throws Owl2ParseException {
        String testString = "#comment at the beginning\rPrefix #comments are allowed here\n(#and here\r :#and here\n = #and here\r<http://www.example.org#>#the last # in <> is not a comment\n )#comment after axiom\nPrefix(rdfs:#comment\n#commbent\r=#comment#\n<http://www.w3.org/2000/01/rdf-schema#>#comment\n)Ontology(#comment\n <http://www.my.example.com/example># comment \nDeclaration(#comment\n Class#comment\n(##\n#\n :Person ) ) \nAnnotationAssertion( rdfs:comment :Person\n\"Represents the set of#not a comment\nall \\\"people#not a comment\\\".\"#comment\r)\n# This is a comment \nSubClassOf( :Person # another comment: #this doesn't count: SubClassOf( :Person\n:Human) #This is another comment\n)# comment at the end";
        this.parseOntology(testString);
    }

    @Test(expected=Owl2ParseException.class)
    public void testPrefixDeclarations() throws Owl2ParseException {
        String testString = "Ontology( <http://www.my.example.com/example>Declaration( Class( :Person ) )SubClassOf( :Person owl:Thing )) ";
        this.parseOntology(testString);
        Assert.fail((String)"Should have thrown Owl2ParseException");
    }

    @Test
    public void testObjectOneOf() throws Owl2ParseException {
        String testString = "Ontology(SubClassOf( <A> ObjectOneOf(<i>)))";
        this.parseOntology(testString);
    }

    @Test
    public void testLiteralParsing() throws Owl2ParseException, IOException {
        String input = "Prefix ( rdfs: = <http://www.w3.org/2000/01/rdf-schema#> )\nPrefix ( a: = <http://www.example.org#> )\nPrefix ( xsd: = <http://www.w3.org/2001/XMLSchema#> )\nOntology(<http://www.example.org/>\nAnnotation(rdfs:comment \"String literal with language\"@en)\nAnnotation(rdfs:comment \"String literal no language\")\nAnnotation(rdfs:label \"Typed literal\"^^xsd:string)\n)";
        this.parseOntology(input);
    }

    @Test
    public void testNaryDataSomeValuesFrom() throws Owl2ParseException {
        String input = "Prefix ( rdfs: = <http://www.w3.org/2000/01/rdf-schema#> )\nPrefix ( a: = <http://www.example.org#> )\nPrefix ( xsd: = <http://www.w3.org/2001/XMLSchema#> )\nOntology(<http://www.example.org/>\nSubClassOf(a:2DFigure \n   DataSomeValuesFrom(a:hasWidth a:hasLength xsd:integer)\n)\nSubClassOf(a:2DFigure \n   DataAllValuesFrom(a:hasWidth a:hasLength xsd:integer)\n)\n)";
        ElkTestAxiomProcessor counter = this.parseOntology(input);
        Set<ElkAxiom> axioms = counter.getAxiomsForType(ElkSubClassOfAxiom.class);
        Assert.assertEquals((long)2L, (long)axioms.size());
        for (ElkAxiom axiom : axioms) {
            ElkSubClassOfAxiom sbAxiom = (ElkSubClassOfAxiom)axiom;
            Assert.assertTrue((boolean)(sbAxiom.getSuperClassExpression() instanceof ElkDataPropertyListRestrictionQualifiedImpl));
            ElkDataPropertyListRestrictionQualifiedImpl superCE = (ElkDataPropertyListRestrictionQualifiedImpl)sbAxiom.getSuperClassExpression();
            Assert.assertEquals((long)2L, (long)superCE.getDataPropertyExpressions().size());
        }
    }

    @Test
    public void testEmptyPrefix() throws Owl2ParseException {
        String testString = "Prefix(:=<>)Ontology(Declaration(Class(:A)))";
        this.parseOntology(testString);
    }

    @Test
    public void testQualifiedNamesInIris() throws Owl2ParseException {
        String testString = "Prefix(p: = <>)Ontology(SubClassOf(p:Class p:Ontology))";
        this.parseOntology(testString);
    }

    @Test
    public void testSWRL() throws Owl2ParseException {
        String testString = "Prefix(:=<www.example.org>) Ontology(<www.example.org#swrl-rule-test> DLSafeRule( Body( ClassAtom(:A Variable(:x)) ) Head( ClassAtom(:B Variable(:x) ) ) ) )";
        this.parseOntology(testString);
    }
}

