/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.Wait;

public class FluentWait<T>
implements Wait<T> {
    public static Duration FIVE_HUNDRED_MILLIS = new Duration(500L, TimeUnit.MILLISECONDS);
    private final T input;
    private final Clock clock;
    private final Sleeper sleeper;
    private Duration timeout = FIVE_HUNDRED_MILLIS;
    private Duration interval = FIVE_HUNDRED_MILLIS;
    private String message = null;
    private List<Class<? extends Throwable>> ignoredExceptions = Lists.newLinkedList();

    public FluentWait(T input) {
        this(input, new SystemClock(), Sleeper.SYSTEM_SLEEPER);
    }

    public FluentWait(T input, Clock clock, Sleeper sleeper) {
        this.input = Preconditions.checkNotNull(input);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)sleeper);
    }

    public FluentWait<T> withTimeout(long duration, TimeUnit unit) {
        this.timeout = new Duration(duration, unit);
        return this;
    }

    public FluentWait<T> withMessage(String message) {
        this.message = message;
        return this;
    }

    public FluentWait<T> pollingEvery(long duration, TimeUnit unit) {
        this.interval = new Duration(duration, unit);
        return this;
    }

    public <K extends Throwable> FluentWait<T> ignoreAll(Collection<Class<? extends K>> types) {
        this.ignoredExceptions.addAll(types);
        return this;
    }

    public FluentWait<T> ignoring(Class<? extends Throwable> exceptionType) {
        return this.ignoreAll((Collection)ImmutableList.of(exceptionType));
    }

    public FluentWait<T> ignoring(Class<? extends Throwable> firstType, Class<? extends Throwable> secondType) {
        return this.ignoreAll((Collection)ImmutableList.of(firstType, secondType));
    }

    public void until(final Predicate<T> isTrue) {
        this.until((Function<? super T, V>)new Function<T, Boolean>(){

            public Boolean apply(T input) {
                return isTrue.apply(input);
            }
        });
    }

    @Override
    public <V> V until(Function<? super T, V> isTrue) {
        long end = this.clock.laterBy(this.timeout.in(TimeUnit.MILLISECONDS));
        Throwable lastException = null;
        while (true) {
            try {
                Object value = isTrue.apply(this.input);
                if (value != null && Boolean.class.equals(value.getClass()) ? Boolean.TRUE.equals(value) : value != null) {
                    return (V)value;
                }
            }
            catch (Throwable e) {
                lastException = this.propagateIfNotIngored(e);
            }
            if (!this.clock.isNowBefore(end)) {
                String toAppend = this.message == null ? " waiting for " + isTrue.toString() : ": " + this.message;
                String timeoutMessage = String.format("Timed out after %d seconds%s", this.timeout.in(TimeUnit.SECONDS), toAppend);
                throw this.timeoutException(timeoutMessage, lastException);
            }
            try {
                this.sleeper.sleep(this.interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    private Throwable propagateIfNotIngored(Throwable e) {
        for (Class<? extends Throwable> ignoredException : this.ignoredExceptions) {
            if (!ignoredException.isInstance(e)) continue;
            return e;
        }
        throw Throwables.propagate((Throwable)e);
    }

    protected RuntimeException timeoutException(String message, Throwable lastException) {
        throw new TimeoutException(message, lastException);
    }
}

