/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.os.CommandLine;

public class FileHandler {
    private static final Method JDK6_CANEXECUTE = FileHandler.findJdk6CanExecuteMethod();
    private static final Method JDK6_SETWRITABLE = FileHandler.findJdk6SetWritableMethod();
    private static final Method JDK6_SETEXECUTABLE = FileHandler.findJdk6SetExecutableMethod();

    public static File unzip(InputStream resource) throws IOException {
        File output = TemporaryFilesystem.getDefaultTmpFS().createTempDir("unzip", "stream");
        new Zip().unzip(resource, output);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(File outputDir, Class<?> forClassLoader, String ... names) throws IOException {
        Zip zip = new Zip();
        for (String name : names) {
            InputStream is = FileHandler.locateResource(forClassLoader, name);
            try {
                zip.unzipFile(outputDir, is, name);
            }
            finally {
                try {
                    Closeables.closeQuietly((Closeable)is);
                }
                catch (Exception e) {}
            }
        }
    }

    private static InputStream locateResource(Class<?> forClassLoader, String name) throws IOException {
        String arch = System.getProperty("os.arch").toLowerCase() + "/";
        ArrayList alternatives = Lists.newArrayList((Object[])new String[]{name, "/" + name, arch + name, "/" + arch + name});
        if (Platform.getCurrent().is(Platform.MAC)) {
            alternatives.add("mac/" + name);
            alternatives.add("/mac/" + name);
        }
        for (String possibility : alternatives) {
            InputStream stream = FileHandler.class.getResourceAsStream(possibility);
            if (stream != null) {
                return stream;
            }
            stream = forClassLoader.getResourceAsStream(possibility);
            if (stream == null) continue;
            return stream;
        }
        throw new IOException("Unable to locate: " + name);
    }

    public static boolean createDir(File dir) throws IOException {
        if ((dir.exists() || dir.mkdirs()) && dir.canWrite()) {
            return true;
        }
        if (dir.exists()) {
            FileHandler.makeWritable(dir);
            return dir.canWrite();
        }
        return FileHandler.createDir(dir.getParentFile());
    }

    public static boolean makeWritable(File file) throws IOException {
        block8: {
            if (file.canWrite()) {
                return true;
            }
            if (JDK6_SETWRITABLE != null) {
                try {
                    return (Boolean)JDK6_SETWRITABLE.invoke((Object)file, true);
                }
                catch (IllegalAccessException e) {
                    break block8;
                }
                catch (InvocationTargetException e) {
                    break block8;
                }
            }
            if (!Platform.getCurrent().is(Platform.WINDOWS)) {
                try {
                    CommandLine cmd = new CommandLine("chmod", "+w", file.getAbsolutePath());
                    cmd.execute();
                    return file.canWrite();
                }
                catch (WebDriverException e1) {
                    throw new WebDriverException((Throwable)e1);
                }
            }
        }
        return false;
    }

    public static boolean makeExecutable(File file) throws IOException {
        block8: {
            if (FileHandler.canExecute(file).booleanValue()) {
                return true;
            }
            if (JDK6_SETEXECUTABLE != null) {
                try {
                    return (Boolean)JDK6_SETEXECUTABLE.invoke((Object)file, true);
                }
                catch (IllegalAccessException e) {
                    break block8;
                }
                catch (InvocationTargetException e) {
                    break block8;
                }
            }
            if (!Platform.getCurrent().is(Platform.WINDOWS)) {
                try {
                    CommandLine cmd = new CommandLine("chmod", "+x", file.getAbsolutePath());
                    cmd.execute();
                    return FileHandler.canExecute(file) == Boolean.TRUE;
                }
                catch (WebDriverException e1) {
                    throw new WebDriverException((Throwable)e1);
                }
            }
        }
        return false;
    }

    public static Boolean canExecute(File file) {
        if (JDK6_CANEXECUTE != null) {
            try {
                return (Boolean)JDK6_CANEXECUTE.invoke((Object)file, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean isZipped(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".xpi");
    }

    public static boolean delete(File toDelete) {
        boolean deleted = true;
        if (toDelete.isDirectory()) {
            for (File child : toDelete.listFiles()) {
                deleted &= child.canWrite() && FileHandler.delete(child);
            }
        }
        return deleted && toDelete.canWrite() && toDelete.delete();
    }

    public static void copy(File from, File to) throws IOException {
        FileHandler.copy(from, to, new NoFilter());
    }

    public static void copy(File source, File dest, String suffix) throws IOException {
        FileHandler.copy(source, dest, suffix == null ? new NoFilter() : new FileSuffixFilter(suffix));
    }

    private static void copy(File source, File dest, Filter onlyCopy) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (source.isDirectory()) {
            FileHandler.copyDir(source, dest, onlyCopy);
        } else {
            FileHandler.copyFile(source, dest, onlyCopy);
        }
    }

    private static void copyDir(File from, File to, Filter onlyCopy) throws IOException {
        if (!onlyCopy.isRequired(from)) {
            return;
        }
        FileHandler.createDir(to);
        String[] children = from.list();
        if (children == null) {
            throw new IOException("Could not copy directory " + from.getPath());
        }
        for (String child : children) {
            if (".parentlock".equals(child) || "parent.lock".equals(child)) continue;
            FileHandler.copy(new File(from, child), new File(to, child), onlyCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File from, File to, Filter onlyCopy) throws IOException {
        if (!onlyCopy.isRequired(from)) {
            return;
        }
        FileChannel out = null;
        FileChannel in = null;
        try {
            in = new FileInputStream(from).getChannel();
            out = new FileOutputStream(to).getChannel();
            long length = in.size();
            long copied = in.transferTo(0L, in.size(), out);
            if (copied != length) {
                throw new IOException("Could not transfer all bytes.");
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(out);
            Closeables.closeQuietly((Closeable)in);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)out);
        Closeables.closeQuietly((Closeable)in);
    }

    private static Method findJdk6CanExecuteMethod() {
        try {
            return File.class.getMethod("canExecute", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method findJdk6SetWritableMethod() {
        try {
            return File.class.getMethod("setWritable", Boolean.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method findJdk6SetExecutableMethod() {
        try {
            return File.class.getMethod("setExecutable", Boolean.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(File toRead) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            int read;
            reader = new BufferedReader(new FileReader(toRead));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[4096];
            while ((read = reader.read(buffer)) != -1) {
                char[] target = new char[read];
                System.arraycopy(buffer, 0, target, 0, read);
                builder.append(target);
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)reader);
        return string;
    }

    private static class NoFilter
    implements Filter {
        private NoFilter() {
        }

        @Override
        public boolean isRequired(File file) {
            return true;
        }
    }

    private static class FileSuffixFilter
    implements Filter {
        private final String suffix;

        public FileSuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean isRequired(File file) {
            return file.isDirectory() || file.getAbsolutePath().endsWith(this.suffix);
        }
    }

    public static interface Filter {
        public boolean isRequired(File var1);
    }
}

