/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MapResolver.java 5461 2010-03-26 16:01:19Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.substitution.resolver;

import java.util.Map;

import org.ow2.util.substitution.IPropertyResolver;

/**
 * Resolve values from a Map.
 * @author Guillaume Sauthier
 */
public class MapResolver implements IPropertyResolver {

    /**
     * Environment.
     */
    private Map<String, String> env;

    public MapResolver(Map<String, String> env) {
        this.env = env;
    }

    /**
     * @param expression a property name
     * @return the value related to the expression, or null if not found.
     */
    public String resolve(final String expression) {
        return env.get(expression);
    }
}
