/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: FallbackResolver.java 5461 2010-03-26 16:01:19Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.substitution.resolver;

import org.ow2.util.substitution.IPropertyResolver;


/**
 * A FallbackResolver is a resolver, usually placed at the end of a chain of resolver
 * and that will provide a default value for any given expression.
 * This permits to have a little less strict resolution process (the substitution engine
 * throwing exceptions if the resolver cannot give a non-null value)
 * @author Guillaume Sauthier
 */
public class FallbackResolver implements IPropertyResolver {

    /**
     * @param expression a property name
     * @return the value related to the expression, or null if not found.
     */
    public String resolve(String expression) {
        // Always return something
        return "[" + expression + ":unresolved]";
    }
}
