/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: StringUtils.java 5461 2010-03-26 16:01:19Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.substitution.engine.util;

/**
 * Utility class for String processing.
 * @author Guillaume Sauthier
 */
public class StringUtils {

    /**
     * The empty String.
     */
    private final static String EMPTY_STRING = "";

    /**
     * Produces an increment String sized given the provided indent value
     * @param indent expected indentation
     * @return increment String
     */
    public static String increment(final int indent) {
        return increment(indent, "  ");
    }

    /**
     * Produces an increment String sized given the provided indent value
     * @param indent expected indentation
     * @param block block of increment to be replicated
     * @return increment String
     */
    public static String increment(final int indent, final String block) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; i++) {
            sb.append(block);
        }
        return sb.toString();
    }

    /**
     * Returns {@code true} if value is null or empty.
     * @param value tested String
     * @return true/false
     */
    public static boolean isEmpty(final String value) {
        return (value == null) || (EMPTY_STRING.equals(value));
    }
}
