/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: VariableElement.java 5461 2010-03-26 16:01:19Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.substitution.engine.element;

import org.ow2.util.substitution.IPropertyResolver;
import org.ow2.util.substitution.engine.IResolvableElement;
import org.ow2.util.substitution.engine.util.StringUtils;

/**
 * A VariableElement is a CompositeElement that knows how to handle multiple level resolution.
 * Example:
 * <code>
 *  ${composite.${value}}
 * </code>
 * @author Guillaume Sauthier
 */
public class VariableElement extends CompositeElement {

    /**
     * Resolve the value result of the composite resolution.
     * @param resolver IPropertyResolver to be used
     * @return a String representation of this resolved element
     */
    @Override
    public String getValue(IPropertyResolver resolver) {
        // Get the composite resolved value
        String name =  super.getValue(resolver);
        // Resolve again
        return resolver.resolve(name);
    }

    /**
     * Produces an indented String representation of this element.
     * @param indent indentation value
     * @return a String representation
     */
    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.increment(indent));


        if (getElements().size() == 1) {
            sb.append("${");
            sb.append(getElements().get(0).toString());
            sb.append("}");
        } else {

            sb.append("${");
            sb.append('\n');
            for (IResolvableElement element : getElements()) {
                sb.append(element.toString(indent + 1));
                sb.append('\n');
            }
            sb.append(StringUtils.increment(indent));
            sb.append("}");

        }

        return sb.toString();
    }
}
