/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: FixedValueElement.java 5461 2010-03-26 16:01:19Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.substitution.engine.element;

import org.ow2.util.substitution.IPropertyResolver;
import org.ow2.util.substitution.engine.IResolvableElement;
import org.ow2.util.substitution.engine.util.StringUtils;

/**
 * a FixedValueElement is a resolvable element that will always return the same value.
 * @author Guillaume Sauthier
 */
public class FixedValueElement implements IResolvableElement {

    /**
     * Fixed value.
     */
    private String value;

    public FixedValueElement(final String value) {
        this.value = value;
    }

    /**
     * Simply return the initially provided value
     * @param resolver not used
     * @return a String representation of this resolved element
     */
    public String getValue(final IPropertyResolver resolver) {
        return value;
    }

    @Override
    public String toString() {
        return toString(0);
    }


    /**
     * Produces an indented String representation of this element.
     * @param indent indentation value
     * @return a String representation
     */
    public String toString(final int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.increment(indent));
        sb.append('\'');
        sb.append(value);
        sb.append("\'");
        return sb.toString();
    }

}
