/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IResolvableElement.java 5461 2010-03-26 16:01:19Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.substitution.engine;

import org.ow2.util.substitution.IPropertyResolver;


/**
 * An {@code IResolvableElement} is a node of the resolution tree that can give a resolved value.
 * @author Guillaume Sauthier
 */
public interface IResolvableElement {

    /**
     * Resolve the value of this element using the given resolver.
     * @param resolver IPropertyResolver to be used
     * @return a String representation of this resolved element
     */
    String getValue(final IPropertyResolver resolver);

    /**
     * Produces an indented String representation of this element.
     * @param indent indentation value
     * @return a String representation
     */
    String toString(final int indent);
}
