/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ISchemaStreamFactory.java 4392 2008-12-15 14:05:41Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.plan.bindings.schemastream;

import java.io.InputStream;

/**
 * Factory for InputStream object built on schema resources.
 * @author Mickaël LEDUQUE
 */
public interface ISchemaStreamFactory {

    /**
     * Provides an InputStream built on the resource.
     * @param schemaResourceName the resource name of the schema (without the package).
     * @return an InputStream built on the resource.
     */
    InputStream getSchemaStream(String schemaResourceName);
}
