/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ExtendedRepository.java 5931 2011-08-02 16:25:46Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.plan.bindings.repository;

import javax.xml.bind.annotation.XmlTransient;

import org.ow2.util.substitution.ISubstitutionEngine;
import org.ow2.util.substitution.engine.DefaultSubstitutionEngine;
import org.ow2.util.substitution.resolver.ChainedResolver;
import org.ow2.util.substitution.resolver.PropertiesResolver;
import org.ow2.util.substitution.resolver.RecursiveResolver;

/**
 * Actual Repository class that will be used by the JAXB2 unmarshaller.
 * @author Mickael LEDUQUE
 */
public class ExtendedRepository extends Repository {

    /**
     * Property substitution engine.
     */
    @XmlTransient
    private ISubstitutionEngine substitutionEngine;

    /**
     * URL has been updated.
     */
    private boolean updatedURL = false;

    /**
     * Default constructor.
     */
    public ExtendedRepository() {
        super();
        this.substitutionEngine = createSubstitutionEngine();
    }

    /**
     * Build a new Substitution engine.
     * @return the substituion engine that will be used for variable value resolution.
     */
    protected ISubstitutionEngine createSubstitutionEngine() {

        // List of resolvers
        ChainedResolver resolver = new ChainedResolver();

        // Create Engine
        DefaultSubstitutionEngine engine = new DefaultSubstitutionEngine();
        engine.setMarkerChar('$');
        engine.setOpeningChar('{');
        engine.setEndingChar('}');
        engine.setResolver(new RecursiveResolver(engine, resolver));

        // Add the system properties as resolver
        resolver.getResolvers().add(new PropertiesResolver(System.getProperties()));

        return engine;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id=");
        String id = this.getId();
        if (id != null) {
            sb.append(id);
        } else {
            sb.append("<not set>");
        }
        sb.append(":type=");
        sb.append(this.getType());
        sb.append(":url=");
        sb.append(this.getUrl());

        return sb.toString();
    }

    /**
     * If the value contains some properties, resolve them and update them.
     * @return URL with the updated value if any
     */
    @Override
    public String getUrl() {
        if (!updatedURL) {
            this.url = substitutionEngine.substitute(this.url);
            updatedURL = true;
        }
        return super.getUrl();
    }


}
