/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: InvalidRepositoryException.java 4392 2008-12-15 14:05:41Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.plan.bindings.exceptions;

/**
 * Exception throw when an invalid repository is encountered.
 * @author Mickaël LEDUQUE
 */
public class InvalidRepositoryException extends Exception {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = -7316302158391217905L;


    /**
     * {@inheritDoc}
     */
    public InvalidRepositoryException() {
        super();
    }

    /**
     * {@inheritDoc}
     */
    public InvalidRepositoryException(final Throwable t) {
        super(t);
    }

    /**
     * {@inheritDoc}
     */
    public InvalidRepositoryException(final String message) {
        super(message);
    }


    /**
     * {@inheritDoc}
     */
    public InvalidRepositoryException(final String message, final Throwable cause) {
        super(message, cause);
    }
}
