/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: TrimmingStringAdapter.java 6266 2012-05-29 08:10:46Z boukadam $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.plan.bindings.deploymentplan;

/**
 * Apply trim() on the String.
 * @author Florent Benoit
 */
public class TrimmingStringAdapter extends javax.xml.bind.annotation.adapters.XmlAdapter<String, String> {

    @Override
    public String marshal(final String text) {
        return (text == null) ? text : text.trim();
    }

    @Override
    public String unmarshal(final String v) throws Exception {
        return (v == null) ? v : v.trim();
    }

}
