/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeploymentPlanFragment.java 4392 2008-12-15 14:05:41Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.plan.bindings.deploymentplan;

import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;

/**
 * Extension of the Deployment binding class with additional data
 * (the deployment status).
 * @author mleduque
 */
public abstract class DeploymentPlanFragment extends Deployment {

    /**
     * If the Deployment has been deployed.
     */
    private boolean deployed = false;

    /**
     * Returns true if the Deployment has been deployed.
     * @return true if the Deployment has been deployed.
     */
    public boolean isDeployed() {
        return this.deployed;
    }

    /**
     * Sets the deployment state.
     * @param deployed the new state.
     */
    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        try {
            sb.append(DeploymentHelper.getId(this));
        } catch (InvalidDeploymentException e) {
            sb.append("<invalid-id>");
        }
        sb.append(", reloadable=");
        try {
            sb.append(DeploymentHelper.isReloadable(this));
        } catch (InvalidDeploymentException e) {
            sb.append("<invalid>");
        }
        sb.append(", useRepository=");
        String repository = null;
        try {
            repository = DeploymentHelper.getRepositoryRef(this);
        } catch (InvalidDeploymentException e) {
            repository = "<invalid-ref>";
        }
        if (repository == null) {
            repository = "<not set>";
        }
        sb.append(repository);
        sb.append("]");

        return sb.toString();
    }
}
