/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IWebserviceDescription.java 4493 2009-02-02 09:25:06Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.metadata.ws.api.xml.struct;

import java.util.List;

/**
 * The IWebserviceDescription the logical view of the <code>webservice-description</code> element.
 *
 * @author Guillaume Sauthier
 */
public interface IWebserviceDescription {

    /**
     * @return the <code>webservice-description-name</code> value.
     */
    String getName();

    /**
     * @return the <code>wsdl-file</code> value (may be null).
     */
    String getWsdlFile();

    /**
     * @return the list of port-component declared in this description.
     */
    List<IPortComponent> getPortComponents();
}
