/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IPortComponent.java 4689 2009-02-23 14:23:05Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.metadata.ws.api.xml.struct;

import javax.xml.namespace.QName;

import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChains;

/**
 * The IPortComponent is the view of the <port-component> element in the webservices.xml.
 *
 * @author Guillaume Sauthier
 */
public interface IPortComponent {

    /**
     * @return the <code>port-component-name</code> value
     */
    String getName();

    /**
     * @return the <code>wsdl-service</code> value (as a QName)
     */
    QName getWsdlService();

    /**
     * @return the <code>wsdl-port</code> value (as a QName)
     */
    QName getWsdlPort();

    /**
     * @return the <code>enable-mtom</code> value.
     */
    boolean isMTOMEnabled();

    /**
     * @return the <code>protocol-binding</code> value.
     */
    String getProtocolBinding();

    /**
     * @return the <code>service-endpoint-interface</code> value.
     */
    String getServiceEndpointInterface();

    /**
     * @return the <code>service-impl-bean</code> content.
     */
    IServiceImplBean getServiceImplBean();

    /**
     * @return the <code>webservice-description</code> element,
     * parent of the port-component
     */
    IWebserviceDescription getParent();

    /**
     * @return the <code>handler-chains</code> element.
     */
    IHandlerChains getHandlerChains();
}
