/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IClassMetadataFinder.java 4493 2009-02-02 09:25:06Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.metadata.ws.api.xml.merge;

import org.ow2.util.ee.metadata.ws.api.IWebservicesCommonClassMetadata;

/**
 * The IClassMetadataFinder is an interface used during webservices.xml
 * merging. It's used to find the classmetadata given a particular SIB link
 * (EJB name for EjbJar or classname for servlet).
 *
 * @author Guillaume Sauthier
 */
public interface IClassMetadataFinder {

    /**
     * Find the Class metadatas relatives to a given "service implementation
     * bean" link (aka, an EJB name when the webservice is an EJB, or a
     * classname when the ws is a POJO)
     * @param link sib link name
     * @return the ClassMetadata associated to the link (may return null if
     * no bean/class is found)
     */
    IWebservicesCommonClassMetadata findClassMetadata(String link);
}
