/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IWebServiceMarker.java 4689 2009-02-23 14:23:05Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.metadata.ws.api.struct;

import javax.xml.namespace.QName;
import java.io.Serializable;

import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChains;

/**
 * Manage WebService metadata.
 * @author Guillaume Sauthier
 */
public interface IWebServiceMarker extends Serializable {

    /**
     * @return true if this marker denotes a class annotated with @WebServiceProvider
     * instead of @WebService.
     */
    boolean isWebServiceProvider();

    /**
     * Set if this class is annotated with @WebService or @WebServiceprovider
     * @param wsProvider
     */
    void setWebServiceProvider(boolean wsProvider);

    /**
     * @return the WSDL location (may be null).
     */
    String getWsdlLocation();

    /**
     * @param wsdlLocation the overrided WSDL location.
     */
    void setWsdlLocation(String wsdlLocation);

    /**
     * @return the overrided wsdl:service name (may be null)
     */
    QName getServiceName();

    /**
     * @param serviceName overriding value for wsdl:service name.
     */
    void setServiceName(QName serviceName);

    /**
     * @return the overrided wsdl:port name (may be null)
     */
    QName getPortName();

    /**
     * @param portName overriding value for wsdl:port name.
     */
    void setPortName(QName portName);

    /**
     * @return the overriding value for the protocol binding URI (may be null)
     */
    String getProtocolBinding();

    /**
     * @param protocolBinding new URI specifying the overriding value for binding URI.
     */
    void setProtocolBinding(String protocolBinding);

    /**
     * @return true if MTOM is enabled (false by default)
     */
    boolean isEnableMtom();

    /**
     * @param enableMtom should MTOM be enabled on this port ?
     */
    void setEnableMtom(boolean enableMtom);

    /**
     * @return the overrided value for Service Endpoint Interface (may be null).
     */
    String getEndpointInterface();

    /**
     * @param serviceEndpointInterface the overriding value for SEI.
     */
    void setEndpointInterface(String serviceEndpointInterface);

    /**
     * @return the name of this web service (only applicable when using @WebService)
     */
    String getName();

    /**
     * Set the name of this serviceweb.
     * @param name name of this webservice.
     */
    void setName(String name);

    /**
     * Set the HandlerChains resolved from deployment descriptor.
     * @param handlerChains HandlerChains resolved from deployment descriptor.
     */
    void setHandlerChains(IHandlerChains handlerChains);

    /**
     * @return the HandlerChains elements resolved from deployment descriptor.
     */
    IHandlerChains getHandlerChains();
}