/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IWebService.java 4493 2009-02-02 09:25:06Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.metadata.ws.api.interfaces;

import org.ow2.util.ee.metadata.ws.api.struct.IWebServiceMarker;

import java.io.Serializable;

/**
 * This interface represents methods which can be call on
 * ClassAnnotationMetadata.<br>
 * It manages WebServices related metadata (marker annotation + values from XML descriptor).
 * @author Guillaume Sauthier
 */
public interface IWebService extends Serializable {

    /**
     * @return IWebServiceMarker object representing ws metadata
     */
    IWebServiceMarker getWebServiceMarker();

    /**
     * Set IWebServiceMarker object.
     * @param ws object representing ws metadata.
     */
    void setWebServiceMarker(IWebServiceMarker ws);

}
