/**
 * OW2 Util
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IWebservicesCommonClassMetadata.java 4493 2009-02-02 09:25:06Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.metadata.ws.api;

import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.ws.api.interfaces.IWebService;

/**
 * The common interface for web services class metadata.
 * @param <C> the common interface for web services class metadata
 * @param <M> the common interface for method metadata
 * @param <F> the common interface for field metadata
 * @author Gael Lalire
 */
public interface IWebservicesCommonClassMetadata<
    C extends IWebservicesCommonClassMetadata<C, M, F>,
    M extends ICommonMethodMetadata<C, M, F>,
    F extends ICommonFieldMetadata<C, M, F>>
        extends ICommonClassMetadata<C, M, F>, IWebService {

}