/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IWarDeployableMetadata.java 4493 2009-02-02 09:25:06Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.metadata.war.api;

import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.IDeployableMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.IEnvironmentRefAccessor;
import org.ow2.util.ee.metadata.ws.api.IWebservicesDeployableMetadata;

import java.util.Collection;

/**
 * IWarDeployableMetadata.
 * @author Gael Lalire
 */
public interface IWarDeployableMetadata extends IDeployableMetadata<WARDeployable>, IEnvironmentRefAccessor, IWebservicesDeployableMetadata {

    /**
     * Add annotation metadata for a given class.
     * @param warClassMetadata metadata of a class.
     */
    void addWarClassMetadata(final IWarClassMetadata warClassMetadata);

    /**
     * Get class annotation metadata.
     * @param className key of the map of annotations bean.
     * @return Bean annotation metadata of a given name.
     */
    IWarClassMetadata getWarClassMetadata(final String className);

    /**
     * Get collections of bean annotation metadata.
     * @return collections of bean annotation metadata.
     */
    Collection<IWarClassMetadata> getWarClassMetadataCollection();

}
