/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployer;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.report.IDeploymentReport;
import org.ow2.util.ee.deploy.impl.report.DeploymentReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployerList<T extends IDeployable<T>>
implements IDeployer<T> {
    public List<IDeploymentReport> deploy(List<IDeployable<T>> deployables) {
        ArrayList<IDeploymentReport> deploymentReports = new ArrayList<IDeploymentReport>();
        for (IDeployable<T> deployable : deployables) {
            DeploymentReport deploymentReport = new DeploymentReport();
            deploymentReport.setDeployable(deployable);
            try {
                this.deploy(deployable);
                deploymentReport.setDeploymentOk(true);
            }
            catch (Exception e) {
                deploymentReport.setException(e);
                deploymentReport.setDeploymentOk(false);
            }
            deploymentReports.add(deploymentReport);
        }
        return deploymentReports;
    }

    public List<IDeploymentReport> undeploy(List<IDeployable<T>> deployables) {
        ArrayList<IDeploymentReport> deploymentReports = new ArrayList<IDeploymentReport>();
        for (IDeployable<T> deployable : deployables) {
            DeploymentReport deploymentReport = new DeploymentReport();
            deploymentReport.setDeployable(deployable);
            try {
                this.undeploy(deployable);
                deploymentReport.setDeploymentOk(true);
            }
            catch (DeployerException e) {
                deploymentReport.setException((Exception)((Object)e));
                deploymentReport.setDeploymentOk(false);
            }
            deploymentReports.add(deploymentReport);
        }
        return deploymentReports;
    }

    public boolean supports(List<IDeployable<?>> deployables) {
        for (IDeployable<?> deployable : deployables) {
            if (this.supports(deployable)) continue;
            return false;
        }
        return true;
    }
}

