/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeploymentReport.java 6234 2012-04-13 14:32:30Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.util.ee.deploy.impl.report;

import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.report.IDeploymentReport;

/**
 * {@inheritDoc}
 */
public class DeploymentReport implements IDeploymentReport {

    /**
     * The {@link IDeployable}
     */
    private IDeployable deployable;

    /**
     * True if the deployment of the deployable is a success.
     */
    private boolean isDeploymentOk;

    /**
     * The {@link Exception} (if the deployment of the deployable has failed)
     */
    private Exception exception;

    /**
     * {@inheritDoc}
     */
    public IDeployable getDeployable() {
        return this.deployable;
    }

    /**
     * {@inheritDoc}
     */
    public boolean isDeploymentOk() {
        return this.isDeploymentOk;
    }

    /**
     * {@inheritDoc}
     */
    public Exception getException() {
        return this.exception;
    }

    /**
     * @param deployable The {@link IDeployable} to set
     */
    public void setDeployable(IDeployable deployable) {
        this.deployable = deployable;
    }

    /**
     * @param exception The {@link Exception} to set
     */
    public void setException(Exception exception) {
        this.exception = exception;
    }

    /**
     * @param deploymentOk The deployment state to set
     */
    public void setDeploymentOk(boolean deploymentOk) {
        this.isDeploymentOk = deploymentOk;
    }
}
