/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WebArchiveClassLoaderURLsHelper.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;


/**
 * Allows to get the URLs used to load any classes in the given WEB archive.
 * @author Florent BENOIT
 * @deprecated
 */
@Deprecated
public final class WebArchiveClassLoaderURLsHelper {

    /**
     * Utility class, no public constructor.
     */
    private WebArchiveClassLoaderURLsHelper() {

    }

    /**
     * Gets URLs from the given WEB Archive that are required for a classloader.
     * @param webArchive the archive to analyze
     * @return a list of URLs or empty URL list if no matching URLs are found.
     * @throws ArchiveException if the URLs are not retrieved
     */
    public static List<URL> getURLs(final IArchive webArchive) throws ArchiveException {
        // Classloader of a war should have access to WEB-INF/classes and all jars of WEB-INF/lib
        // Build list of matching URLs.
        Iterator<URL> itResources;
        try {
            itResources = webArchive.getResources();
        } catch (ArchiveException e) {
            throw new ArchiveException("Cannot get resources on the given archive '" + webArchive + "'.", e);
        }
        List<URL> classLoaderURLs = new ArrayList<URL>();

        // Root URL of the WAR
        URL warURL = webArchive.getURL();

        // WEB-INF/classes ?
        URL webInfClassesURL = webArchive.getResource("WEB-INF/classes");
        boolean webinfClassesFound = false;
        if (webInfClassesURL != null) {
            classLoaderURLs.add(webInfClassesURL);
            webinfClassesFound = true;
        }

        // For each resource, try to search matching WEB-INF/ URLs
        while (itResources.hasNext()) {
            URL currentURL = itResources.next();

            // Remove start of the URL
            int filePos = currentURL.toExternalForm().indexOf(warURL.toExternalForm());
            if (filePos >= 0) {
                filePos += warURL.toExternalForm().length();
            }
            // Compute relative path
            String relativePath = currentURL.toExternalForm().substring(filePos);
            if (relativePath.startsWith("!/")) {
                relativePath = relativePath.substring(2);
            } else if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }

            // Check for WEB-INF/classes URL if not already found
            if (!webinfClassesFound) {
                if (relativePath.startsWith("WEB-INF/classes/")) {
                    int index = currentURL.toExternalForm().indexOf(relativePath);
                    URL webinfClassesURL = null;
                    try {
                        webinfClassesURL = new URL(currentURL.toExternalForm().substring(0, index) + "WEB-INF/classes/");
                    } catch (MalformedURLException e) {
                        throw new ArchiveException("Unable to build URL for WEB-INF/classes on the given archive '" + webArchive
                                + "'.", e);
                    }
                    classLoaderURLs.add(webinfClassesURL);
                    webinfClassesFound = true;
                }
            }

            // Keep valid URLs
            if (relativePath.startsWith("WEB-INF/lib/") && relativePath.endsWith(".jar")) {
                classLoaderURLs.add(currentURL);
            }
        }

        //

        // Return list
        return classLoaderURLs;

    }

}
