/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeployableEntry.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.helper;

import java.io.File;

/**
 * Entry representing the data when we want to add data to an existing Deployable.
 * @author Florent BENOIT
 *
 */
public class DeployableEntry {

    /**
     * Path to the file that is representing the file to add.
     */
    private File file = null;

    /**
     * Name of the entry to add.
     */
    private String name = null;

    /**
     * @return the file of the entry.
     */
    public File getFile() {
        return file;
    }

    /**
     * Sets the file to use in this entry.
     * @param file the given file
     */
    public void setFile(final File file) {
        this.file = file;
    }

    /**
     * @return the name of the entry.
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name of the entry.
     * @param name the given name entry
     */
    public void setName(final String name) {
        this.name = name;
    }

}
