/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeployableDetectVisitor.java 6306 2012-11-19 13:04:06Z albertil $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.helper;

import org.ow2.util.asm.AnnotationVisitor;
import org.ow2.util.asm.commons.EmptyVisitor;
import org.ow2.util.ee.deploy.api.deployable.ArchiveType;

/**
 * This visitor try to find the type of an archive.
 * @author Florent Benoit
 */
public class DeployableDetectVisitor extends EmptyVisitor {

    /**
     * Type of the archive.
     */
    private ArchiveType archiveType = null;

    /**
     * MDB annotation.
     */
    private static final String MDB_ANNOTATION = "Ljavax/ejb/MessageDriven;";

    /**
     * Stateless annotation.
     */
    private static final String STATELESS_ANNOTATION = "Ljavax/ejb/Stateless;";

    /**
     * Stateful annotation.
     */
    private static final String STATEFUL_ANNOTATION = "Ljavax/ejb/Stateful;";

    /**
     * Singleton annotation.
     */
    private static final String SINGLETON_ANNOTATION = "Ljavax/ejb/Singleton;";


    /**
     * Singleton annotation.
     */
    private static final String MANAGED_BEAN_ANNOTATION = "Ljavax/annotation/ManagedBean;";

    /**
     * Visits an annotation of the class.
     * @param desc the class descriptor of the annotation class.
     * @param visible <tt>true</tt> if the annotation is visible at runtime.
     * @return a non null visitor to visit the annotation values.
     */
    @Override
    public AnnotationVisitor visitAnnotation(final String desc, final boolean visible) {
        // update value only if it is not yet detected
        if (archiveType == null) {
            if (desc.equals(MDB_ANNOTATION) || desc.equals(STATEFUL_ANNOTATION) || desc.equals(STATELESS_ANNOTATION)
                    || desc.equals(SINGLETON_ANNOTATION) || desc.equals(MANAGED_BEAN_ANNOTATION)) {
                this.archiveType = ArchiveType.EJB3JAR;
            }
        }

        return this;
    }

    /**
     * Gets the archive type.
     * @return the archive type.
     */
    public ArchiveType getArchiveType() {
        return archiveType;
    }

}
