/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WebModuleImpl.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.deployment.ear;

import org.ow2.util.ee.deploy.api.deployment.ear.WebModule;

/**
 * Defines a WEB module inside an application.xml file.
 * @author Florent Benoit
 */
public class WebModuleImpl extends AbsModuleImpl implements WebModule {

    /**
     * Name of the context-root.
     */
    private String contextRoot = null;

    /**
     * Gets the context-root name for this module.
     * @return the name of the context-root
     */
    public String getContextRoot() {
        return contextRoot;
    }

    /**
     * Sets the given context root.
     * @param contextRoot the given context-root value
     */
    public void setContextRoot(final String contextRoot) {
        this.contextRoot = contextRoot;
    }

}
