/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EARInfoImpl.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.deployment.ear;

import java.util.LinkedList;
import java.util.List;

import org.ow2.util.ee.deploy.api.deployment.ear.ConnectorModule;
import org.ow2.util.ee.deploy.api.deployment.ear.EJBModule;
import org.ow2.util.ee.deploy.api.deployment.ear.IEARInfo;
import org.ow2.util.ee.deploy.api.deployment.ear.JavaModule;
import org.ow2.util.ee.deploy.api.deployment.ear.Module;
import org.ow2.util.ee.deploy.api.deployment.ear.WebModule;

/**
 * An EAR is a collection of Modules.
 * @author Florent Benoit
 */
public class EARInfoImpl implements IEARInfo {

    /**
     * Library directory.
     */
    private String libraryDirectory = DEFAULT_LIBRARY_FOLDER;

    /**
     * List of connector modules.
     */
    private List<ConnectorModule> connectorModules = null;

    /**
     * List of EJB modules.
     */
    private List<EJBModule> ejbModules = null;

    /**
     * List of Java modules.
     */
    private List<JavaModule> javaModules = null;

    /**
     * List of Web modules.
     */
    private List<WebModule> webModules = null;

    /**
     * Default constructor.
     */
    public EARInfoImpl() {
        // Use LinkedList to preserve the order
        this.connectorModules = new LinkedList<ConnectorModule>();
        this.ejbModules = new LinkedList<EJBModule>();
        this.javaModules = new LinkedList<JavaModule>();
        this.webModules = new LinkedList<WebModule>();
    }

    /**
     * @return list of modules.
     */
    public List<Module> getModules() {
        // List of all modules : concatenation
        List<Module> allModules = new LinkedList<Module>();

        // Add connectors
        for (ConnectorModule connectorModule : connectorModules) {
            allModules.add(connectorModule);
        }

        // Add EJB
        for (EJBModule ejbModule : ejbModules) {
            allModules.add(ejbModule);
        }

        // Add clients
        for (JavaModule javaModule : javaModules) {
            allModules.add(javaModule);
        }

        // Add Webs
        for (WebModule webModule : webModules) {
            allModules.add(webModule);
        }

        return allModules;
    }

    /**
     * @return list of Connector modules.
     */
    public List<ConnectorModule> getConnectors() {
        return connectorModules;
    }

    /**
     * @return list of EJB modules.
     */
    public List<EJBModule> getEJBs() {
        return ejbModules;
    }

    /**
     * Add the given EJB module to the list of EJB modules.
     * @param ejbModule the module to add
     */
    public void addEJBModule(final EJBModule ejbModule) {
        ejbModules.add(ejbModule);
    }

    /**
     * Add the given Web module to the list of Web modules.
     * @param webModule the module to add
     */
    public void addWebModule(final WebModule webModule) {
        webModules.add(webModule);
    }

    /**
     * Add the given Connector module to the list of Connector modules.
     * @param connectorModule the module to add
     */
    public void addConnectorModule(final ConnectorModule connectorModule) {
        connectorModules.add(connectorModule);
    }

    /**
     * Add the given Java module to the list of Java modules.
     * @param javaModule the module to add
     */
    public void addJavaModule(final JavaModule javaModule) {
        javaModules.add(javaModule);
    }

    /**
     * @return list of Client container modules.
     */
    public List<JavaModule> getClients() {
        return javaModules;
    }

    /**
     * @return list of Web modules.
     */
    public List<WebModule> getWebs() {
        return webModules;
    }

    /**
     * Sets the library-directory.
     * @param libraryDirectory the given library folder
     */
    public void setLibraryDirectory(final String libraryDirectory) {
        this.libraryDirectory = libraryDirectory;
    }

    /**
     * @return the library-directory.
     */
    public String getLibraryDirectory() {
        return libraryDirectory;
    }

}
