/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AbsModuleImpl.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.deployment.ear;

import org.ow2.util.ee.deploy.api.deployment.ear.Module;

/**
 * Defines a common abstract module.
 * @author Florent Benoit
 *
 */
public abstract class AbsModuleImpl implements Module {

    /**
     * Path to the module.
     */
    private String path = null;


    /**
     * Alternative Deployment descriptor.
     */
    private String altDd = null;

    /**
     * @return the Path to the module.
     */
    public String getPath() {
        return path;
    }

    /**
     * Defines the path for this module.
     * @param path the path to the module.
     */
    public void setPath(final String path) {
        this.path = path;
    }

    /**
     * @return alt-dd value.
     */
    public String getAltDd() {
        return altDd;
    }

    /**
     * Defines the alternative Deployment Desc for this module.
     * @param altDd the alternative Deployment Desc.
     */
    public void setAltDd(final String altDd) {
        this.altDd = altDd;
    }
}
