/**
 * EasyBeans
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AbsDeployerList.java 6234 2012-04-13 14:32:30Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.util.ee.deploy.impl.deployer;

import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.report.IDeploymentReport;
import org.ow2.util.ee.deploy.impl.report.DeploymentReport;

import java.util.ArrayList;
import java.util.List;

/**
 * Abstract class that defines common methods to deploy a list of deployable.
 * @author Jeremy Cazaux
 */
public abstract class AbsDeployerList<T extends IDeployable<T>> implements IDeployer<T> {

    /**
     * {@inheritDoc}
     */
    public List<IDeploymentReport> deploy(final List<IDeployable<T>> deployables) {
        List<IDeploymentReport> deploymentReports = new ArrayList<IDeploymentReport>();

        for (IDeployable<T> deployable: deployables) {
            DeploymentReport deploymentReport = new DeploymentReport();
            deploymentReport.setDeployable(deployable);
            try {
                deploy(deployable);
                deploymentReport.setDeploymentOk(true);
            } catch (Exception e) {
                deploymentReport.setException(e);
                deploymentReport.setDeploymentOk(false);
            }
            deploymentReports.add(deploymentReport);
        }

        return deploymentReports;
    }

    /**
     * {@inheritDoc}
     */
    public List<IDeploymentReport> undeploy(final List<IDeployable<T>> deployables) {
        List<IDeploymentReport> deploymentReports = new ArrayList<IDeploymentReport>();

        for (IDeployable<T> deployable: deployables) {
            DeploymentReport deploymentReport = new DeploymentReport();
            deploymentReport.setDeployable(deployable);
            try {
                undeploy(deployable);
                deploymentReport.setDeploymentOk(true);
            } catch (DeployerException e) {
                deploymentReport.setException(e);
                deploymentReport.setDeploymentOk(false);
            }
            deploymentReports.add(deploymentReport);
        }

        return deploymentReports;
    }

    /**
     * {@inheritDoc}
     */
    public boolean supports(final List<IDeployable<?>> deployables) {

        for (IDeployable deployable: deployables) {
            if (!supports(deployable)) {
                return false;
            }
        }
        return true;
    }
}
