/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeployableMetadata.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.deployable.metadata;

import org.ow2.util.ee.deploy.api.deployable.IDeployable;

/**
 * Metadata of a deployable.
 * @author Gael Lalire
 * @param <E> the deployable type
 */
public abstract class DeployableMetadata<E extends IDeployable<E>> {

    /**
     * The deployable.
     */
    private E deployable;

    /**
     * No-arg Constructor.
     */
    public DeployableMetadata() {
    }

    /**
     * Constructor.
     * @param deployable the deployable
     */
    public DeployableMetadata(final E deployable) {
        this();
        setDeployable(deployable);
    }

    /**
     * @return the deployable
     */
    public E getDeployable() {
        return deployable;
    }

    /**
     * Sets the given deployable.
     * @param deployable the given deployable
     */
    public void setDeployable(final E deployable) {
        this.deployable = deployable;
    }

}
