/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WARDeployableImpl.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.deployable;

import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;

/**
 * Implementation for a WAR.
 * @author Florent Benoit
 */
public class WARDeployableImpl extends AbsDeployable<WARDeployable> implements WARDeployable {

    /**
     * Name of the context-root.
     */
    private String contextRoot = null;

    /**
     * Defines and create a deployable for the given archive.
     * @param archive the given archive.
     */
    public WARDeployableImpl(final IArchive archive) {
        super(archive);
    }

    /**
     * @return the list of the context root for this deployable.<br>
     * Note: It can be the context-root defined at the EAR level.
     */
    public String getContextRoot() {
        return contextRoot;
    }

    /**
     * Defines the name of the context-root.
     * @param contextRoot the given context-root for this war file
     */
    public void setContextRoot(final String contextRoot) {
        this.contextRoot = contextRoot;
    }
}
